<?php

namespace Modules\SMS\Drivers;


use Modules\SMS\Drivers\Driver;
use Modules\SMS\Interfaces\PhoneSearchParams;
use Modules\SMS\Responses\Magfa as MagfaResponse;
use Modules\Home\Models\Config as ConfigModel;
use SoapClient;

class Magfa extends Driver
{

    protected $handle;
    protected $certificate;
    protected $senderNumber;

    public function __construct($domin, $user, $pass, $senderNumber)
    {
        $this->handle = new SoapClient("https://sms.magfa.com/services/urn:SOAPSmsQueue?wsdl",array(
            'login' => $user,'password' => $pass,'features' => SOAP_USE_XSI_ARRAY_TYPE
        ));

        $this->certificate = [
            'Domain'  => $domin,
            'UserName'  => $user,
            'PassWord' => $pass,
        ];

        $this->senderNumber = $senderNumber;
    }

    public function send($msg, $to, $from, $lookup, $callback = null)
    {
        if (!empty($callback)) {
            throw new \Exception("Callback URLs are not implemented for Plivo", 1);
        }
        $config = ConfigModel::getWithLocale()->first();
        $config = json_decode($config->xconfig_data, true);

        if ($lookup == 'sendOtp')
            $msg = $config['sms']['forgenCodeSMS'] ? str_replace('{code}', $msg, $config['sms']['forgenCodeSMS']) : null;
        elseif ($lookup == 'wellcome')
            $msg = $config['sms']['registerSMS'];
        elseif ($lookup == 'invoiceSuccess')
            $msg = $config['sms']['acceptBuySMS'] ? str_replace('{refCode}', $msg, $config['sms']['acceptBuySMS']) : null;

        if (!$msg)
            return;
        
        $params = array(
            'domain'=>$this->certificate['Domain'],
            'messageBodies'=>[$msg],
            'recipientNumbers'=>[$to],
            'senderNumbers'=>[$this->senderNumber]
        );

        return new MagfaResponse($this->handle->__soapCall('enqueue',$params));
    }

    public function searchNumber(PhoneSearchParams $search)
    {
        return new PlivoResponse($this->handle->search_phone_numbers($search->toArray()));
    }

    public function buyNumber($phone)
    {
        $params = [
            'number' => $phone
        ];

        return new PlivoResponse($this->handle->buy_phone_number($params));
    }

    public function sellNumber($phone)
    {
        $phone = str_replace("+", "", $phone);
        $params = [
            'number' => $phone
        ];
        return new PlivoResponse($this->handle->unrent_number($params));
    }
}
