<?php

namespace Modules\SMS\Drivers;


use Modules\SMS\Drivers\Driver;
use Modules\SMS\Interfaces\PhoneSearchParams;
use Modules\SMS\Responses\Kavenegar as KavenegarResponse;
use Modules\SMS\Entities\kavenegar\KavenegarApi;
use SoapClient;

class Kavenegar extends Driver
{

    protected $handle;
    protected $certificate;

    public function __construct($api)
    {
        $this->handle =  new KavenegarApi($api);

        $this->certificate = [
            'api'  => $api,
        ];

    }

    public function send($msg, $to,$from, $lookup = null, $callback = null)
    {
        if (!empty($callback)) {
            throw new \Exception("Callback URLs are not implemented for Plivo", 1);
        }

        try{
            
            $sender = $from ?? "10004346";
            try {
                $result = $lookup ? (is_array($msg)? $this->handle->VerifyLookup($to,$msg[0],$msg[1],null, $lookup) : $this->handle->VerifyLookup($to,$msg,null,null, $lookup) ) : $this->handle->Send($sender,$to,$msg); //VerifyLookup
            } catch (\Throwable $th) {
                return null;
            }
            
            return new KavenegarResponse($result);

        }
        catch(\Kavenegar\Exceptions\ApiException $e){
            // در صورتی که خروجی وب سرویس 200 نباشد این خطا رخ می دهد
            echo $e->errorMessage();
        }
        catch(\Kavenegar\Exceptions\HttpException $e){
            // در زمانی که مشکلی در برقرای ارتباط با وب سرویس وجود داشته باشد این خطا رخ می دهد
            echo $e->errorMessage();
        }
    }

    public function searchNumber(PhoneSearchParams $search)
    {
       
    }

    public function buyNumber($phone)
    {
        
    }

    public function sellNumber($phone)
    {
       
    }
}
