<?php

namespace Modules\SMS\Drivers;


use Modules\SMS\Drivers\Driver;
use Modules\SMS\Interfaces\PhoneSearchParams;
use Modules\SMS\Responses\Asanak as AsanakResponse;
use Modules\Home\Models\Config as ConfigModel;
use SoapClient;

class Asanak extends Driver
{

    protected $handle;
    protected $certificate;
    protected $senderNumber;

    public function __construct( $user, $pass, $senderNumber)
    {
        
        $this->certificate = [
            'UserName'  => $user,
            'PassWord' => $pass,
        ];

        $this->senderNumber = $senderNumber;
    }

    public function send($msg, $to, $from, $lookup, $callback = null)
    {
        if (!empty($callback)) {
            throw new \Exception("Callback URLs are not implemented for Plivo", 1);
        }
        $config = ConfigModel::getWithLocale()->first();
        $config = json_decode($config->xconfig_data, true);

        
        if($lookup){
            $url = "https://api.asanak.com/v1/sms/template";
            $data = array(
                "template_id" => "337",
                "destination" => $to,
                "send_to_blacklist" => 0,
                "parameters" => array(
                    "code1" => $msg
                ),
            );
            $headers = array(
                "api_key: glcwebservice",
                "api_secret: 1a60a37093fe8589bb04ee999477b8c3150612ea7a043cb76e3ac8cbc61a0864",
                "Content-Type: application/json"
            );

            $ch = curl_init($url);
            curl_setopt_array($ch, array(
                CURLOPT_HTTPHEADER => $headers,
                CURLOPT_POSTFIELDS => json_encode($data),
                CURLOPT_POST => 1,
                CURLOPT_RETURNTRANSFER => 1,
                CURLOPT_FOLLOWLOCATION => 1,
                CURLOPT_MAXREDIRS => 5,
                CURLOPT_TIMEOUT => 10,
                CURLOPT_SSL_VERIFYHOST => 0
            ));
            $response = curl_exec($ch);
            curl_close($ch);
            $response = json_decode($response, true);
        }
        else{
            if ($lookup == 'sendOtp')
                $msg = $config['sms']['forgenCodeSMS'] ? str_replace('{code}', $msg, $config['sms']['forgenCodeSMS']) : null;
            elseif ($lookup == 'wellcome')
                $msg = $config['sms']['registerSMS'];
            elseif ($lookup == 'invoiceSuccess')
                $msg = $config['sms']['acceptBuySMS'] ? str_replace('{refCode}', $msg[0], $config['sms']['acceptBuySMS']) : null;

            if (!$msg)
            return;

            $url = "https://panel.asanak.com/webservice/v1rest/sendsms";
            $data = array(
                'username' => $this->certificate['UserName'],
                'password' => $this->certificate['PassWord'],
                'source' => $this->senderNumber,
                'destination' => $to,
                'message' => $msg
            );
            
            $headers = array(
                "Content-Type: application/json"
            );
            $ch = curl_init($url);
            curl_setopt_array($ch, array(
                CURLOPT_HTTPHEADER => $headers,
                CURLOPT_POSTFIELDS => json_encode($data),
                CURLOPT_POST => 1,
                CURLOPT_RETURNTRANSFER => 1,
                CURLOPT_FOLLOWLOCATION => 1,
                CURLOPT_MAXREDIRS => 5,
                CURLOPT_TIMEOUT => 10,
                CURLOPT_SSL_VERIFYHOST => 0
            ));
        
            $response = curl_exec($ch);
            
        try {
            return new AsanakResponse($response);
        } catch (HttpException $ex) {
            echo $ex;
        }
    }
    }

    public function searchNumber(PhoneSearchParams $search)
    {
        return new PlivoResponse($this->handle->search_phone_numbers($search->toArray()));
    }

    public function buyNumber($phone)
    {
        $params = [
            'number' => $phone
        ];

        return new PlivoResponse($this->handle->buy_phone_number($params));
    }

    public function sellNumber($phone)
    {
        $phone = str_replace("+", "", $phone);
        $params = [
            'number' => $phone
        ];
        return new PlivoResponse($this->handle->unrent_number($params));
    }
}
