<?php

return [
    'name' => 'SMS',
    'lang' => [
    	'default' => 'message'
    ],

     /**
     * The SMS service to use. twilio or plivo
     */
    'driver' => env('SMS_DRIVER', 'kavenegar'),

    /**
     * Plivo settings
     */
    'plivo' => [
        'token' => env('PLIVO_AUTH_TOKEN'),
        'user'  => env('PLIVO_AUTH_ID'),
        'from'  => env('PLIVO_FROM', null), //Default from phone number
    ],

    /**
     * Twilio settings
     */
    'twilio' => [
        'token' => env('TWILIO_AUTH_TOKEN'),
        'user'  => env('TWILIO_AUTH_SID'),
        'from'  => env('TWILIO_FROM', null), //Default from phone number
    ],

    /**
     * Bandwidth settings
     */
    'bandwidth' => [
        'secret' => env('BANDWIDTH_SECRET'),
        'token' => env('BANDWIDTH_TOKEN'),
        'user_id' => env('BANDWIDTH_USER_ID'),
        'from'  => env('BANDWIDTH_FROM', null), //Default from phone number
        'fallback_url' => env('BANDWIDTH_FALLBACK_URL', null),
        'application_id' => env('BANDWIDTH_APPLICATION_ID', null),
    ],

    /**
     * sornasms settings
     */
    'sornasms' => [
        'portalCode' => env('SORNASMS_AUTH_POSTAL_CODE'),
        'user'  => env('SORNASMS_AUTH_USER'),
        'pass'  => env('SORNASMS_AUTH_PASS', null), //Default from phone number
    ],

    'magfa' => [
        'domin' => env('MAGFA_DOMIN'),
        'user'  => env('MAGFA_AUTH_USER'),
        'pass'  => env('MAGFA_AUTH_PASS', null), //Default from phone number
        'sendernumber' => env('MAGFA_SENDER_NUMBER'),
    ],

    'asanak' => [
        'user'  => env('ASANAK_AUTH_USER'),
        'pass'  => env('ASANAK_AUTH_PASS', null), //Default from phone number
        'sendernumber' => env('ASANAK_SENDER_NUMBER'),
    ],

    'kavenegar' =>[
        'api' => '6D4F5A35384F436F37486444364E2F302F4C555961756A5A544735327A716D58',
    ],
];
