<?php namespace Modules\Publisher\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Publisher\Models\Publisher;

use Config;
use Input;
use File;
use App;
use DB;

class PublisherController extends BackendController {
    public $title = "publisher";

    //## list
	public function index()
	{
        $this->field[] =  array('php' => 'echo \'<div style="text-align: center;"><img src="/pic/publisher/\' . $item["xpublisherid"] . "w120h100c1/". str_random() . ".png?nocache=1" . \'" alt="" /></div>\';',
           'name' => trans('language.picture'), 'css' => 'width: 3%');
        $this->field[] =  array('php' => 'echo $item["xpublisher_name"];', 'name' =>  @t('name'), 'css' => 'width: 10%', 'sortable' => 'xpublisher_name');
        $this->field[] =  array('php' => 'echo $item["xpublisher_desc"];', 'name' =>  @t('description'), 'css' => 'width: 10%');
 
        $this->field[] =  array('php' => 'echo $item["xrank"];', 'name' => trans('language.display rank'), 'css' => 'width: 10%', 'sortable' => 'xrank');

        $this->list = Publisher::getResult()
            ->whereRaw($this->query->where)
            ->orderByRaw($this->query->order)
            ->havingRaw($this->query->having);
            

        $this->paginate();        
        
	}

    //## new
    public function create($id = 0)
    {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id)
    {
        $this->layout->content->list = Publisher::find($id);
        $this->layout->content->imgExist = File::exists(config('upload.' . config('app.controller')) . "/$id");
        $this->layout->title = $this->title;
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $book = Publisher::updateById($frm,$id);
        $this->saveFile($id);
        die('[[OK]]');
        
    }

    //## delete
    public function delete($id)
    {
        Publisher::remove($id);
        
    }

    //## delete Image
    public function deleteImage($id)
    {
        File::delete(config('upload.' . config('app.controller'))  . "/$id");
        die('[[OK]]');
    }

    //## set combo
    public function setCombo()
    {
    
         $this->layout->GroupList = $this->layout->content->GroupList = [1];
         $this->layout->SubGroupList  = $this->layout->content->SubGroupList  = [1];
    }

}