@foreach($params as $name => $param)
@php $prettyName = @$iteration ? "{$section}[row{$iteration}][$name]" : "{$section}[$name]" @endphp
@switch($param['type'])
@case('incremental')
<input type="hidden" class="reset" name={{ $prettyName }} value="{{ @$values[$name] }}" />
@break
@case('text')
<div class="@if(@$param['responsive']) {{$param['responsive']}} @else col-md-6 mb-3 @endif">
    <label>{{ $param['text'] }}</label>
    {!! Form::text($prettyName, @$values[$name] ?? @$param['default'], array('class' => 'form-control', )) !!}
</div>
@break
@case('textarea')
<div class="@if(@$param['responsive']) {{$param['responsive']}} @else col-md-12 mb-3 @endif">
    <label>{{ $param['text'] }}</label>
    {!! Form::textarea($prettyName, @$values[$name] ?? @$param['default'], array('class' => 'form-control', )) !!}
</div>
@break
@case('tinymce')
<div class="col-xs-12">
    <label>{{ $param['text'] }}</label>
    <div class="textarea">
        {!! Form::textarea($prettyName, @$values[$name] ?? @$param['default'], array('class' => 'tinymce_editor', )) !!}
    </div>
</div>
@break

@case('switch')
<div class="@if(@$param['responsive']) {{$param['responsive']}} @else col-md-6 mb-3 @endif">
    <label>{{ $param['text'] }}</label>
    <div class="form-group">
        <div class="input-icon">
            {!! Form::hidden($prettyName, 0)!!}
            <label class="el-switch el-switch-green">
                {!! Form::checkbox($prettyName, 1, @$values[$name],array('class'=>'no-checker')) !!}
                <span class="el-switch-style"></span>
            </label>
        </div>
    </div>
</div>
@break
@case('comboBox')
<div class="@if(@$param['responsive']) {{$param['responsive']}} @else col-md-6 mb-3 @endif">
    <label>{{ $param['text'] }}</label>
    {!! Form::select($prettyName, @$param['values'], @$values[$name] ?? @$param['default'], ['class'=>'form-control','data-advancedselect'
    =>
    'select2']) !!}
</div>
@break
@case('image')
@php $prettyImageName = @$iteration ? "parametersImage[row{$iteration}][$name]" : "generalImage[$name]" @endphp
<div class="@if(@$param['responsive']) {{$param['responsive']}} @else col-md-6 mb-3 @endif">
    <p> {{ $param['text'] }} </p>
    <input type="hidden" class="reset" name={{$prettyName."[uuid]"}} value="{{ @$values[$name]['uuid'] }}" />
    @include('admin.partial.fileInput', [
    'exist' => @$values[$name]['uuid'] && Storage::disk('publicRoot')->exists('page/widgets/'. @$values[$name]['uuid']),
    'src' =>'/pic/page.widgets/' . @$values[$name]['uuid'] . '.jpg?x-oss-process=image/resize,m_lfit,h_150,w_200/quality,q_60' ,
    'name' => $prettyImageName,
    'type' => 'image',
    'id' => @$values[$name]['uuid']. "/$pagewidget_id",
    'style'=>'height: 164px;' ,
    'class'=>'reset',
    'removeCallback' => 'function(response,obj){arguments[1].closest(".fileinput").prev().val("");}'])
</div>
@break
@case('video')

@php $prettyImageName = @$iteration ? "parametersImage[row{$iteration}][$name]" : "generalImage[$name]" @endphp
<div class="col-md-6 mb-3">
    <p>فایل {{ $param['text'] }} </p>
    <input type="hidden" class="reset" name={{$prettyName."[file][uuid]"}} value="{{ @$values[$name]['file']['uuid'] }}" />
    @include('admin.partial.fileInput', [
    'exist' => @$values[$name]['file']['uuid'],// && Storage::disk('publicRoot')->exists('page/widgets/'. @$values[$name]['file']['uuid']),
    'href' =>'/video/page.widgets/' . @$values[$name]['file']['uuid'] . '.mp4' ,
    'name' => $prettyImageName."[file]",
    'type' => 'video',
    'id' => @$values[$name]['file']['uuid'] . "/$pagewidget_id",
    'action' => 'widgetDeleteImage',
    'style'=>'height: 164px;' ,
    'class'=>'reset',
    'removeCallback' => 'function(response,obj){arguments[1].closest(".fileinput").prev().val("");}'
    ])
</div>
<div class="col-md-6 mb-3">
    <p> پوستر {{ $param['text'] }} </p>
    <input type="hidden" class="reset file-uuid-input" name={{$prettyName."[poster][uuid]"}} value="{{ @$values[$name]['poster']['uuid'] }}" />
    @include('admin.partial.fileInput', [
    'exist' => @$values[$name]['poster']['uuid'],// && Storage::disk('publicRoot')->exists('page/widgets/'. @$values[$name]['poster']['uuid']),
    'src' =>'/pic/page.widgets/' . @$values[$name]['poster']['uuid'] . '.jpg?x-oss-process=image/resize,m_lfit,h_150,w_200/quality,q_60' ,
    'name' => $prettyImageName."[poster]",
    'type' => 'image',
    'action' => 'widgetDeleteImage',
    'id' => @$values[$name]['poster']['uuid']. "/$pagewidget_id",
    'style'=>'height: 164px;' ,
    'class'=>'reset',
    'removeCallback' => 'function(response,obj){arguments[1].closest(".fileinput").prev().val("");}'
    ])
</div>
@break
@case('button')
<div class="col-md-6 mb-3">
    <label>عنوان {{ $param['text'] }} </label>
    {!! Form::text($prettyName."[title]", @$values[$name]['title'], array('class' => 'form-control', )) !!}
</div>
<div class="col-md-6 mb-3">
    <label>لینک {{ $param['text'] }} </label>
    {!! Form::text($prettyName."[link]", @$values[$name]['link'], array('class' => 'form-control', )) !!}
</div>
@break
@case('parameters')
<div class="col-xs-12">
    <p style="margin: 20px 15px 0 0;"> {{ $param['text'] }} </p>

    <div class="static-row-js">
    @var('counterIndex',1)
        @foreach( @$values[$name] ?is_array(@$values[$name][0])?@$values[$name]:@$values[$name]: [1] as $pValue)
        <div class="row item-list-{{$name}}">
            <div class="col-xs-12 margin-bottom-10">
                <div class="custom-item-list-toolbar">
                    <a class="reset remBut rem" style="padding: 0;" target="edit_frame" onclick="App.removeRow(this, 'item-list-{{$name}}');">
                        <i class="fa fa-trash"></i>
                    </a>
                    <a class="addBut" style="padding: 0;" onclick="App.duplicateRow('item-list-{{$name}}');" href="javascript:void(0)">
                        <i class="fa fa-plus-square"></i>
                    </a>
                </div>
            </div>

            @include('page::admin.edit.formBuild',['params' => $param['params'], 'values' => $pValue, 'iteration' => $counterIndex, 'pagewidget_id' => $pagewidget_id, 'section' => "sourceModel[{$name}]"])
        </div>
        @var($counterIndex,++$counterIndex)
        @endforeach
    </div>

</div>
@break
@default
@endswitch

@endforeach