<?php namespace Modules\Page\Models;

use App\Models\Model;
use DB;
use Modules\Shop\Models\ShopQuery;
use Modules\Shop\Models\Product;
use Modules\Home\Models\Tag;

class Widget extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'widget';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    protected $guarded = ['id'];

    protected $casts = [
        'xrank' => 'int',
    ];


    public function items()
    {
       return $this->hasMany(WidgetItem::class,'widget_id');
    }

    public function page() {
        return $this->belongTo(PageWidget::class, 'id');
    }

    public function source(){
        return $this->hasOne(ShopQuery::class,'id','source_id');
    }

    public function datasource(){
        $value = $this->source;
        $productList = [];
        $productList['id'] = $value['id'];
        $productList['title'] = $value['name'];
        $productList['subtitle'] = $value['subname'];
        $productList['type'] = 'product';
        $productList['link'] = '/Product/query/' . $value['id'];
        $productList['list'] = Product::with(['group'])->where('xstatus', 1)
            ->when($value['groups_id'], function ($query, $data) {
                return $query->whereIn('group_id', explode(',', $data));
            })
            ->when($value['tag_id'], function ($query, $data) {
                $tag = Tag::find($data);
                return $query->whereIn('id', $tag->products->pluck('id'));
            })
            ->when($value['sortby'], function ($query, $data) {
                return $query->orderBy($data, 'desc');
            })
            ->when($value['count'], function ($query, $data) {
                return $query->take($data);
            })->get();

        
            return $productList;
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table("$instance->table AS w")
            ->leftJoin('widget_items AS wi', 'w.id', '=', 'wi.widget_id')
            ->groupBy('w.id')
            ->select(['w.*', "w.{$instance->primaryKey} AS xid"]);
        return $res;
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();

        if ($id) {
            $res = $instance->destroy($id);
            parent::deleteFile($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return $res;
    }
}