<?php namespace Modules\Page\Models;

use App\Models\Model;
use DB;

class Tracker extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'page_track';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'id';
    public $lang = false;
    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    protected $guarded = ['id'];

    protected $casts = [
        'id' => 'int',
    ];


    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table("$instance->table AS p1")
            ->leftJoin('widget_page','page_id','=','p1.id')
            ->leftJoin('widget','widget.id','=','widget_page.widget_id')
            ->groupBy('p1.id')
            ->select(['p1.*', "p1.{$instance->primaryKey} AS xid",DB::raw("GROUP_CONCAT(CONCAT('{\"id\":\"',widget_page.id,'\", \"name\":\"', widget.name,'\"}' ) ORDER BY widget_page.xrank ASC) AS pageWidgetids")])
            ->orderBy('p1.id','asc');
            
        return $res;
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();

        if ($id) {
            $res = $instance->destroy($id);
            parent::deleteFile($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return $res;
    }
}