<?php namespace Modules\Page\Models;

use App\Models\Model;
use DB;
use Modules\Comment\Models\Comment;

class PageWidget extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'widget_page';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
    public $lang = false;

    protected $guarded = ['id'];

    protected $casts = [
        'xrank' => 'int',
    ];


    public function widget()
    {
       return $this->hasOne(Widget::class,'id','widget_id');
    }

    public function page() {
        return $this->belongsTo(Page::class, 'page_id');
    }
    
    /**
     * Get all of the comments.
     */
    public function comments() {
        return $this->morphMany(Comment::class, 'xcommentable');
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getWidgets($id) {
        $instance = new static();

        $res = DB::table("$instance->table AS pw")
            ->leftJoin('widget AS w', 'pw.xparentid', '=', 'w.xpageid')
            ->leftJoin('page_number AS pn', 'pn.id', '=', 'pw.xpageid')
            ->select(['pw.*', "pw.{$instance->primaryKey} AS xid", "w.xpage_title AS xparent_title"]);
        return $res;
    }


    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table("$instance->table AS pw")
            ->leftJoin('widget AS w', 'pw.widget_id', '=', 'w.id')
            ->leftJoin('page_number AS pn', 'pn.id', '=', 'pw.page_id')
            ->select(['pw.*', "pw.{$instance->primaryKey} AS xid", "w.name", DB::raw("pn.name AS pageName")]);
        return $res;
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();

        if ($id) {
            $res = $instance->destroy($id);
            parent::deleteFile($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return $res;
    }
}