<?php namespace Modules\Page\Models;

use App\Models\Model;
use DB;

class CommonPage extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'xxpage';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'xpageid';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    protected $guarded = ['xpageid'];

    protected $casts = [
        'xrank' => 'int',
    ];

    public function group() {
        return $this->hasOne(Page::class, 'id', 'xparentid');
    }

    public function widgets()
    {
       return $this->hasMany(PageWidget::class,'page_id');
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table("$instance->table AS p1")
            ->groupBy('p1.xpageid')
            ->select(['p1.*', "p1.{$instance->primaryKey} AS xid"])
            ->orderBy('p1.xpageid','asc');
            
        return $res;
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();

        if ($id) {
            $res = $instance->destroy($id);
            parent::deleteFile($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return $res;
    }
}