<?php
namespace Modules\Page\Http\Controllers\Index;

use App\Http\Controllers\IndexController;
use App\Traits\UploadMultiFile;
use File;
use Modules\Goldiran\Traits\GS;
use Modules\Home\Traits\Location;
use Modules\Page\Models\Page;
use Modules\Page\Models\OldPage;
use Modules\Page\Models\PageWidget;

class PageController extends IndexController {
    use GS;
    /*
    |--------------------------------------------------------------------------
    | Home Controller
    |--------------------------------------------------------------------------
    |
    | This controller renders your application's "dashboard" for users that
    | are authenticated. Of course, you are free to change or remove the
    | controller as you wish. It is just here to get your app started!
    |
     */

    public function render($title){
        $title = \implode('/',func_get_args());
        $page = Page::where('url',!empty($title) ? $title : '/')->where('xlang' , \App::getLocale())->first();
        if(!$page) abort(404);
        if($page->redirect_url)  return redirect($page->redirect_url,301);
        if(@$page->layout && $page->layout == 'amp'){
            $this->layout = view('index.goldiran.amp-blank-layout', array('title' => $this->title));
        }
            
        $pagewidgets = PageWidget::leftJoin('widget','widget.id','=','widget_id')
                                    ->where('page_id',$page->id)
                                    ->where('widget_page.xstatus',1)
                                    ->where('widget.xstatus',1)
                                    ->orderBy('xrank','asc')
                                    ->select(['widget_page.config as values','widget.blade','widget_page.id as pageWidgetId'])
                                    ->get();

        if(!$page->widget_config){
            $widgetConfigs = ['desktop' => ['js' => [],'css'=>[]],'mobile' => ['js' => [],'css'=>[]]];
            foreach ($pagewidgets as  $widget) {
                $path = \View::getFinder()->find($widget->blade);
                if($path){
                    $path = dirname($path);
                    if(file_exists($path . "/config.json")){
                        $configData = json_decode(file_get_contents($path . '/config.json'),true);
                        if($configData){
                            foreach($configData['desktop']['js'] as $value){
                                $widgetConfigs['desktop']['js'][$value] = 1;
                            }
                            foreach($configData['desktop']['css'] as $value){
                                $widgetConfigs['desktop']['css'][$value] = 1;
                            }
                            foreach($configData['mobile']['js'] as $value){
                                $widgetConfigs['mobile']['js'][$value['name']] = $value['src'];
                            }
                            foreach($configData['mobile']['css'] as $value){
                                $widgetConfigs['mobile']['css'][$value] = 1;
                            }
                        }
                    }                    
                }
            }

            $page->widget_config = json_encode($widgetConfigs);
            $page->save();
        }
        
        $this->layout->title = $page->seo_title ?? ($page->xpage_title ?? '');
        $this->layout->canonical = $page->seo_canonical;
        $this->layout->seoNoIndex = $page->seo_noindex;
        $this->layout->description = $page->seo_description;
        $this->layout->widgetConfig = json_decode($page->widget_config,true);
        $this->layout->content = view('page::index.render', [
            'pagewidgets' => $pagewidgets,
            'page' => $page
        ]);
    }

    
    /**
     * Show the application dashboard to the user.
     *
     * @return Response
     */
    public function index($id,$title2 = '') {
        if(!is_numeric($id)){
            $title = str_replace('-',' ',$id);
            $page = OldPage::where('url',$title)->first();
        }else{
            $page = OldPage::find($id);
            if(!$page) abort(404);
            $title = str_replace(' ','-',$page->url ?? $page->xpage_title);
            return redirect("/page/$title",301);
        }
        if(!$page) abort(404);
        $title = $page->seo_title ?? ($page->xpage_title ?? '');

        if ($page->xparentid) //'/Page/'.$page->parent->xpageid
        {
            $breadcrumb[] = ['title' => $page->parent->xpage_title, 'href' => ''];
        }

        //$breadcrumb[] = ['title' => $title, 'href' => ''];
        //$this->layout->breadcrumb = $breadcrumb;

        $imgExist = File::exists(config('upload.' . config('app.controller')) . "/$page->xpageid");

        //$attachmentList = self::attachmentFiles($page->xpageid);

        $this->layout->title = $title;
        $this->layout->description = $page->seo_description;
        $this->layout->canonical = $page->seo_canonical;
        $this->layout->content = view('page::index.page_detail', [
            'page' => $page,
            'imgExist' => $imgExist,
          //  'attachmentList' => $attachmentList,
        ]);
    }

}
