<?php

namespace Modules\Page\Http\Controllers\Index;

use App\Http\Controllers\IndexController;
use Modules\Goldiran\Traits\GS;
use Modules\Goldiran\Models\Product;
use Intervention\Image\Facades\Image;
use Modules\Page\Models\Tracker;
use Carbon\Carbon;
use Request;

class LandingController extends IndexController
{
    use GS;

    /*
    |--------------------------------------------------------------------------
    | Home Controller
    |--------------------------------------------------------------------------
    |
    | This controller renders your application's "dashboard" for users that
    | are authenticated. Of course, you are free to change or remove the
    | controller as you wish. It is just here to get your app started!
    |
     */

    public function __construct() {
        $this->layout = 'index.goldiran.landing-layout';
    }

    //private function getDataUrlFromSetad(){
        // $newPictures = [];
        // foreach ($pictures as $key => $value) {
        //     $newPictures[$value['model']] = ['id' => $value['id'], 'name' => $value['name']];
        // }
        // file_put_contents($path . '/pictures.json',json_encode($newPictures));
        // $newPictures = [];
        // foreach ($pictures as $key => $value) {
        //     $url = 'https://core.master.plus.gi/api/MarketingProduct/GetProductImages?id=' . $value['id'];
        //     $response = json_decode(file_get_contents($url),true);
        //     $newPictures[$key] = [
        //         'id' => $value['id'],
        //         'name' => $value['name'],
        //         'url' => $response[0]['imageLink']
        //     ];
        // }
        // file_put_contents($path . '/picturesUrl.json',json_encode($newPictures));
        // dd($newPictures);
    //}

    function tImage($url){
        if($url){
            $img = imagecreatefromjpeg('https://cdn.master.plus.gi/images/original/' . $url); 
            $remove = imagecolorallocate($img, 255, 255, 255);
            imagecolortransparent($img, $remove);
            header('Content-Type: image/png');
            imagepng($img);
            die; 
        }
        return null;
    }

    public function w($token)
    {
        $path = dirname(\View::getFinder()->find('page::index.landing.warranty.index'));
        $widgetConfig = json_decode(file_get_contents($path . '/config.json'),true);
        $this->layout->widgetConfig = $widgetConfig;
        $pictures = json_decode(file_get_contents($path . '/picturesUrl.json'),true);
        
        $information = ($this->gsGetReguarantProducts($token));
        //$img = Image::make('https://cdn.master.plus.gi/images/original/84cd2f4a-ee05-4819-9e5c-c34e397fec24.jpg');
        
        //$img->trim()->save(public_path().'/out/pic.png');
        
        if(!property_exists($information->products,'ReguarantProduct') || $token == 'K'){
            $this->tracker($information->mobileNo,$token,'{"action":"noProduct","payload":""}');
            return redirect('/request');
        }
        $products = Product::all();
        $this->layout->content = view(
            'page::index.landing.warranty.index',
            [
                'token' => $token,
                'info' => $information,
                'products' => $products,
                'pictures' => $pictures
            ]
        );

        $this->layout->title = "تمدید گارانتی محصولات ال جی و جی پلاس | خدمات گلدیران";
        $this->layout->description = "تمدید گارانتی محصولات ال جی و جی پلاس | افزایش مدت ضمانت و گارانتی یخچال و فریزر، ماشین لباسشویی، ماشین ظرفشویی و ساید بای ساید و ...";
        $this->tracker($information->mobileNo,$token,'{"action":"openPage","payload":""}');
    }

    public function survey($title){
        return redirect('/surveys/success-offer',301);
    }

    public function illegal(){
        return redirect('/offers/technician',301);
    }

    public function trackerAction(){
        $mobile = \Input::get('mobile');
        $activity = \Input::get('activity');
        $token = \Input::get('token');
        if($activity && $mobile){
            $this->tracker($mobile,$token,$activity);
        }
        return response()->json(['success' => true]);
    }
    private function tracker($user, $token, $activity){
        $data = [            
            'user_id' => null,
            'user_payload' => $user,
            'ip' => Request::getClientIp(),
            'date' => Carbon::now(),
            'page_id' => 1,
            'page_type' => 1,
            'user_agent'=> Request::server('HTTP_USER_AGENT'),
            'payload' => $token,
            'activity' => $activity
        ];

        Tracker::updateById($data);
    }
}
