<?php namespace Modules\Page\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Config;
use File;
use Input;
use Modules\Page\Models\Widget;
use Modules\Page\Models\WidgetItem;
use Modules\Shop\Models\ShopQuery;

class WidgetsController extends BackendController {

    public $title = "widget";

    //## list
    public function index() {
        
        $this->field[] = array('php' => 'echo $item["name"];', 'name' => @t('name'), 'css' => 'width: 10%', 'sortable' => 'xpage_title');
        
        $this->list = Widget::getResult();

        $this->paginate();
        $this->layout->content->listBtn['showClone'] = true;

    }

    //## new
    public function create($id = 0) {
        $this->layout->title = $this->title;
        
    }

    //## edit
    public function edit($id) {
        $this->layout->content->list = Widget::find($id);
        $this->layout->content->sourceList = ShopQuery::pluck('name','id')->prepend('بدون منبع داده',0);
        $this->layout->content->imgExist = File::exists(config('upload.' . config('app.controller')) . "/$id");
        $firstPicExist = [];
        $secondPicExist = [];
        foreach ($this->layout->content->list->items as $key => $value) {
            $firstPicExist[$value->id] = File::exists(config('upload.' . config('app.controller')). '/first' . "/$value->id");
            $secondPicExist[$value->id] = File::exists(config('upload.' . config('app.controller')). '/second' . "/$value->id");
        }
        $this->layout->content->firstPicExist = $firstPicExist;
        $this->layout->content->secondPicExist = $secondPicExist;
        $this->layout->title = $this->title;
    
    }

    //## store
    public function store($id) {
        $frm = Input::get('frm');
        $items = Input::get('items');
        
        $widget = Widget::updateById($frm, $id);
        $subImg = [];
        
        if ($items) {
            foreach ($items as $key => $value) {
                if(empty($value['id'])){
                    $res = $widget->items()->create($value);
                }
                else{
                    $res = WidgetItem::updateById($value, $value['id']);
                }
                $subImg[$key] = $res->id;
            }
        }

        $this->saveFile($widget->id,$subImg);

        die('[[OK]]');

    }

    public function clone($id) {
        $model = Widget::find($id);
        $newModel = $model->replicate();
        $newModel->name = 'تکرار- ' . $newModel->name;
        $newModel->push();

        foreach ($model->items as $item) {
            $newItem = $item->replicate();
            //$newItem->push();
            $newModel->items()->save($newItem);
            // $file = 'images/folder/one.jpg';
            // $newfile = 'Images/folder/one_thumb.jpg';
            // if (!copy($file, $newfile)) {
            //     echo "failed to copy";
            // }
        }
        die('[[OK]]');

    }
    public function deleteItem($id) {
        return WidgetItem::remove($id);
    }

    //## delete
    public function delete($id) {
        return Widget::remove($id);
    }

    //## delete Image
    public function deleteImg($id) {
        File::delete(config('upload.' . config('app.controller')) . "/$id");
        die('[[OK]]');
    }

    //## set combo
    public function setCombo() {
        
    }

}