<?php namespace Modules\Page\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Config;
use File;
use Input;
use Modules\Page\Models\Widget;
use Modules\Page\Models\PageWidget;
use DB;

class PageWidgetsController extends BackendController {

    public $title = "widget";

    //## list
    public function index() {
        
        $this->field[] = array('php' => 'echo $item["name"];', 'name' => @t('widget'), 'css' => 'width: 10%', 'sortable' => 'name');
        $this->field[] = array('php' => 'echo $item["pageName"];', 'name' => @t('page'), 'css' => 'width: 10%', 'sortable' => 'page_id');
        $this->field[] = array('php' => 'echo $item["xrank"];', 'name' => @trans('language.display rank'), 'css' => 'width: 10%', 'sortable' => 'xrank');
        $this->list = PageWidget::getResult();

        $this->paginate();

    }

    //## new
    public function create($id = 0) {
        $this->layout->title = $this->title;
        
    }

    //## edit
    public function edit($id) {
        $this->layout->content->list = PageWidget::find($id);
       // $this->layout->content->imgExist = File::exists(config('upload.' . config('app.controller')) . "/$id");
        $this->layout->title = $this->title;
    
    }

    //## store
    public function store($id) {
        $frm = Input::get('frm');
        //$items = Input::get('items');
        
        $widget = PageWidget::updateById($frm, $id);
        

       // $this->saveFile($widget->id);

        die('[[OK]]');

    }


    //## delete
    public function delete($id) {
        PageWidget::remove($id);

    }

    //## delete Image
    public function deleteImg($id) {
        File::delete(config('upload.' . config('app.controller')) . "/$id");
        die('[[OK]]');
    }

    //## set combo
    public function setCombo() {
        
        $pageList = DB::table('page_number')->pluck('name','id');
        $this->layout->pageList = $this->layout->content->pageList = $pageList;
        $this->layout->widgetList = $this->layout->content->widgetList = Widget::all()->pluck('name','id');
    }

}