<?php

namespace Modules\Page\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use App\Traits\UploadMultiFile;
use Config;
use File;
use Input;
use App\Exports\Export;
use Modules\Page\Models\Page;
use Modules\Page\Models\Widget;
use Modules\Page\Models\PageWidget;
use Webpatser\Uuid\Uuid;
use DB;
use Auth;
use Modules\Account\Models\ItemPermission;

class PageController extends BackendController
{
    use UploadMultiFile;

    public $title = "page";

    //## list
    public function index()
    {
        $this->field[] = array('php' => 'echo $item["title"];', 'name' => @t('name'), 'css' => 'width: 10%', 'sortable' => 'title');        
        $this->list = Page::getResult();
        
        $roles = Auth::user()->roles->pluck('xroleid');
        $permission = ItemPermission::whereIn('role_id',$roles)->where('module_id',9)->get();
        if($permission && $permission->count() > 0){
            $this->list->whereIn('p1.id',$permission->pluck('controllerable_id'));
        }
        
        $this->paginate();

        $this->layout->toolbar['showTools'] = true;
        $this->layout->content->listBtn['widgetView'] = true;
        $this->layout->content->listBtn['showCheckbox'] = true;
        $this->layout->content->listBtn['showClone'] = true;
    }

    private function addAccessToUser($id,$type){
        $roles = Auth::user()->roles->pluck('xroleid');
        $permission = ItemPermission::whereIn('role_id',$roles)->where('module_id',9)->get();
        if($permission){
            if(is_array($type)){
                foreach ($type as $key => $value) {
                    $this->addOnePermission($roles[0],9,$id,$value);
                }
            }else{
                $this->addOnePermission($roles[0],9,$id,$type);
            }
        }
    }

    private function addOnePermission($role,$module,$id,$type){
        $item = [
            'role_id' => $role,
            'module_id' => $module,
            'controllerable_id' => $id,
            'type' => $type
        ];
        ItemPermission::updateById($item);
    }

    private function isAccess($id,$type){
        $roles = Auth::user()->roles->pluck('xroleid');
        $permission = ItemPermission::whereIn('role_id',$roles)->where('module_id',9)->get();
        if($permission && $permission->count()){
            $permission = $permission->where('controllerable_id',$id)->whereIn('type',$type);
            if($permission->count() > 0) 
                return true;
            
            return false;
        }
        return true;
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id)
    {
        if(!$this->isAccess($id,[1,3])) die('[[عدم دسترسی]]');
        $this->layout->content->list = Page::find($id);
        $this->layout->title = $this->title;
        //$this->layout->content->attachmentList = json_encode(self::attachmentFiles($id));
    }

    //## store
    public function store($id)
    {
        if(!$this->isAccess($id,1)) die('[[عدم دسترسی]]');
        $frm = Input::get('frm');
        if (!$frm['url']) $frm['url'] = $frm['title'];
        $page = Page::updateById($frm, $id);
        
        if($id == 0){
            //$this->addAccessToUser($page->id,[1,3]);
        }
        die('[[OK]]');
    }


    public function editItems($id)
    {
        $pageWidget = PageWidget::find($id);
        if(!$this->isAccess($pageWidget->page->id,[1,3]))  die('[[عدم دسترسی]]');

        $this->layout->title = 'items';
        $this->layout->storeMethod = 'storeItems';
        $this->layout->content = view('page::admin.edit.widgets');

        $this->layout->content->widget = $pageWidget;
    }

    public function storeItems($id)
    {
        $parameters = Input::get('parameters');
        $general = Input::get('general');
        $sourceModel = Input::get('sourceModel');
        $externalData = Input::get('externalData');
        $parametersImages = Input::file('parametersImage');
        $generalImages = Input::file('generalImage');
        
        $pageWidget = PageWidget::find($id);
        if(!$this->isAccess($pageWidget->page->id,1))  die('[[عدم دسترسی]]');

        $newConfigParametersId = $parameters ? array_column($parameters, 'id') : [];
        $maxIDParameters = $newConfigParametersId ? (int)max($newConfigParametersId) : 0;

        //get Config Widget Image types
        // $widgetConfig = \json_decode($pageWidget->widget->config,true);
        // $generalImages = [];
        // $parametersImages = [];
        // foreach($widgetConfig['general'] as $key => $value){
        //     if($value['type'] == 'image')
        //         $generalImages[] = $key;
        // }

        // foreach ($widgetConfig['parameters'] as $key => $value) {
        //     if($value['type'] == 'image')
        //         $parametersImages[] = $key;
        // }   

        // set id and uuid for parameters
        $imageForSaving = [];
        foreach ($parameters && is_array(current($parameters)) ? $parameters : [] as $key => $value) {
            if (!(int)@$value['id']) {
                $parameters[$key]['id'] = ++$maxIDParameters;
            }

            if ($parametersImages)
                foreach ($parametersImages[$key] ?? [] as $imageKey => $imageName) {
                    if(is_array($imageName)){
                       foreach ($imageName as $key2 => $value2) {
                           $this->assignUUid($imageForSaving,$parameters[$key][$imageKey][$key2],$imageKey,$value2);
                       }    
                    }else{
                        $this->assignUUid($imageForSaving,$parameters[$key][$imageKey],$imageKey,$imageName);
                    }
                }
        }

        if ($generalImages)
            foreach ($generalImages as $imageKey => $imageName) {
                $general[$imageKey]['uuid'] = Uuid::generate()->string;
                $general[$imageKey]['ext'] = $imageName->getClientOriginalExtension();
                $imageForSaving[] = [
                    'uuid' => $general[$imageKey]['uuid'],
                    'name' => $imageKey,
                    'file' => $imageName
                ];
            }

        $pageWidgetConfig = json_decode($pageWidget->config, true);
        $oldConfigParametersId = $pageWidgetConfig && array_key_exists('parameters', $pageWidgetConfig) ? array_column(['parameters'], 'id') : [];
        $differenceIds = array_diff($oldConfigParametersId, $newConfigParametersId);
        //self::removeRelation($differenceIds);

        $this->storeImages($imageForSaving);

        foreach ($sourceModel ?? [] as $key => $value) {
            if(is_array($value))
                $sourceModel[$key] = array_values($value);
        }
        $config = [
            'general' => $general,
            'parameters' => $parameters ? is_array(current($parameters)) ? array_values($parameters) : $parameters : [],
            'source_model' => $sourceModel,
            'externalData' => $externalData,
            'command' => ""
        ];
        
        $pageWidget->config = json_encode($config);

        $pageWidget->save();
        //SurveyAnswer::syncOneToMany($frm,$question->otherid,'question_id');

        die('[[OK]]');
    }

    private function assignUUid(&$imageForSaving,&$array,$key,$file){
        $array['uuid'] = Uuid::generate()->string;
        $array['ext'] = $file->getClientOriginalExtension();
        $imageForSaving[] = [
            'uuid' => $array['uuid'],
            'name' => $key,
            'file' => $file,
            
        ];  
    }

    private function storeImages($imageForSaving)
    {

        foreach ($imageForSaving as $key => $value) {
            $path = $value['file']->storeAs(strtolower(config('app.controller')) . '/widgets', $value['uuid'], 'publicRoot');
        }
    }

    private function removeRelation($ids)
    {

        //remove uploade image and video
        foreach ($ids as $key => $value) {
            \Storage::disk('publicRoot')->delete(config('app.controller') . '/widgets' . $value['uuid']);
        }
    }

    public function editNewWidget($id)
    {
        if(!$this->isAccess($id,[1,3]))  die('[[عدم دسترسی]]');

        $this->layout->title = 'widgets';
        $this->layout->storeMethod = 'storeNewWidgets';
        $this->layout->content = view('page::admin.edit.newWidget');
        $this->layout->content->widgetsList = Widget::pluck('name', 'id');
        $this->layout->content->pageWidgets = PageWidget::where('page_id', $id)->orderBy('xrank', 'asc')->get();
    }

    public function storeNewWidgets($id)
    {
        if(!$this->isAccess($id,1))  die('[[عدم دسترسی]]');

        $widgets = Input::get('list');
        $pageWidget = PageWidget::where('page_id',$id)->get();

        $current = $pageWidget->pluck('id')->toArray();
        $records = collect($widgets)->mapWithKeys(function ($attributes, $id) {
            if (! is_array($attributes)) {
                [$id, $attributes] = [$attributes, []];
            }
            $key = $attributes['id'];
            return $key ? [$key => $attributes] : [\Str::random(12) => $attributes];
        })->all();

        $detach = array_diff($current, array_keys($records));

        if($detach){
            PageWidget::destroy($detach);
        }
        if ($widgets) {
            foreach ($widgets as $key => $value) {
                $value['page_id'] = $id;
                $res = PageWidget::updateById($value, $value['id']);
            }
        }
        
        die('[[OK]]');
    }
    //## delete
    public function delete($id)
    {
        if(!$this->isAccess($id,2))  die('[[عدم دسترسی]]');

        $model = Page::find($id);
        foreach ($model->widgets as $item) {
            $item->delete();
        }
        $model->delete();
        die('[[OK]]');
    }

    public function widgetDeleteImage($uuid,$id){
        $pageWidget = PageWidget::find($id);
        if(!$this->isAccess($pageWidget->page->id,2))  die('[[عدم دسترسی]]');

        $pageWidget = PageWidget::find($id);
        \preg_match('/"uuid"\s*:\s*"'.$uuid.'"/',$pageWidget->config,$matches);
        if(!empty($matches)){
            $pageWidget->config = \preg_replace('/"uuid"\s*:\s*"'.$uuid.'"/',' ',$pageWidget->config);
            $pageWidget->save();
            //$ret = \Storage::disk('publicRoot')->delete(config('app.controller') . '/widgets/' . $uuid);
            die('[[OK]]');
        }
        die('[[ERROR]]');
    }

    //## delete Image
    public function deleteImg($id)
    {
        File::delete(config('upload.' . config('app.controller')) . "/$id");
        die('[[OK]]');
    }

    //## set combo
    public function setCombo()
    {
        $this->layout->GroupList = $this->layout->content->GroupList = [1];
        $this->layout->SubGroupList = $this->layout->content->SubGroupList = [1];

        $this->layout->parentList = Page::pluck('title', 'id')->prepend('', '');
    }

    public function excelExport()
    {
       
        $checkall = Input::get('checkall');
        $listchk = Input::get('listchk');

        $this->list = Page::getResult()->orderBy('p1.id', 'asc')->select(["p1.title", 'p1.xpage_subtitle', 'p1.xpage_desc', 'p2.title as parentName', 'p1.xpage_menu', 'p1.type', 'p1.xpage_footer', 'p1.xstatus', DB::raw("CONCAT('/page/', p1.id,'/', REPLACE(p1.title,' ','-')) as link")]);
        if (!$checkall && $listchk) {
            $this->list->whereIn('p1.id', array_keys($listchk));
        }
        $this->setQueryToList();

        if (!$this->list->orders) {
            $this->list->orders = [[
                "column" => "p1.id",
                "direction" => "desc",
            ]];
        }
        $heading = ['عنوان', 'زیر عنوان', 'توضیحات', 'نام والد', 'قرارگیری در منو', 'نوع', 'قرارگیری در فوتر', 'وضعیت', 'لینک'];
        return (new Export($this->list, $heading))->download('pages.xlsx');
    }

    public function clone($id) {
        $model = Page::find($id);
        $newModel = $model->replicate();
        $newModel->title = 'تکرار- ' . $newModel->title;
        $newModel->url = $newModel->url . '-duplicate';
        $newModel->push();

        foreach ($model->widgets as $item) {
            $newItem = $item->replicate();
            $newModel->widgets()->save($newItem);
        }
        die('[[OK]]');

    }
}
