<?php

namespace Modules\Page\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use App\Traits\UploadMultiFile;
use Config;
use File;
use Input;
use App\Exports\Export;
use Modules\Page\Models\Page;
use Modules\Page\Models\CommonPage;
use Modules\Page\Models\Widget;
use Modules\Page\Models\PageWidget;
use Webpatser\Uuid\Uuid;
use DB;

class CommonPageController extends BackendController
{
    

    public $title = "page";

    //## list
    public function index()
    {
        $this->field[] = array('php' => 'echo $item["xpage_title"];', 'name' => @t('name'), 'css' => 'width: 10%', 'sortable' => 'title');
        $this->field[] = array('php' => 'echo $item["redirect_url"];', 'name' => @t('redirect'), 'css' => 'width: 10%', 'sortable' => 'redirect_url');
        $this->list = CommonPage::getResult();

        $this->paginate();

        $this->layout->toolbar['showTools'] = true;
        //$this->layout->content->listBtn['widgetView'] = true;
        $this->layout->content->listBtn['showCheckbox'] = true;
        $this->layout->content->listBtn['showClone'] = true;
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id)
    {
        $this->layout->content->list = CommonPage::find($id);
        $this->layout->title = $this->title;
        //$this->layout->content->attachmentList = json_encode(self::attachmentFiles($id));
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        if (!$frm['url']) $frm['url'] = $frm['xpage_title'];
        $page = CommonPage::updateById($frm, $id);
        $filesList = Input::get('filesUpload', []);

        //self::storeAttachmentFiles($id, $filesList);
        die('[[OK]]');
    }




    //## delete
    public function delete($id)
    {
        $model = CommonPage::find($id);
        foreach ($model->widgets as $item) {
            $item->delete();
        }
        $model->delete();
        die('[[OK]]');
    }

 

    //## delete Image
    public function deleteImg($id)
    {
        File::delete(config('upload.' . config('app.controller')) . "/$id");
        die('[[OK]]');
    }

    //## set combo
    public function setCombo()
    {
        $this->layout->GroupList = $this->layout->content->GroupList = [1];
        $this->layout->SubGroupList = $this->layout->content->SubGroupList = [1];

        $this->layout->parentList = CommonPage::pluck('xpage_title', 'xpageid')->prepend('', '');
    }

    public function excelExport()
    {
        $checkall = Input::get('checkall');
        $listchk = Input::get('listchk');

        $this->list = CommonPage::getResult()->orderBy('p1.id', 'asc')->select(["p1.title", 'p1.xpage_subtitle', 'p1.xpage_desc', 'p2.title as parentName', 'p1.xpage_menu', 'p1.type', 'p1.xpage_footer', 'p1.xstatus', DB::raw("CONCAT('/page/', p1.id,'/', REPLACE(p1.title,' ','-')) as link")]);
        if (!$checkall && $listchk) {
            $this->list->whereIn('p1.id', array_keys($listchk));
        }
        $this->setQueryToList();

        if (!$this->list->orders) {
            $this->list->orders = [[
                "column" => "p1.id",
                "direction" => "desc",
            ]];
        }
        $heading = ['عنوان', 'زیر عنوان', 'توضیحات', 'نام والد', 'قرارگیری در منو', 'نوع', 'قرارگیری در فوتر', 'وضعیت', 'لینک'];
        return (new Export($this->list, $heading))->download('pages.xlsx');
    }

    public function clone($id) {
        $model = CommonPage::find($id);
        $newModel = $model->replicate();
        $newModel->title = 'تکرار- ' . $newModel->title;
        $newModel->url = $newModel->url . '-duplicate';
        $newModel->push();

        foreach ($model->widgets as $item) {
            $newItem = $item->replicate();
            $newModel->widgets()->save($newItem);
        }
        die('[[OK]]');

    }
}
