<?php

namespace Modules\Page\Entities;
use Input;
use Str;
use Modules\Goldiran\Traits\Products;
use Modules\Home\Traits\Location;
use Modules\Page\Models\Page;
use Modules\Page\Models\PageWidget;

class CalculateData{
    use Location,Products;
    public static function getGeoLocation($data,$id=null){
        return  self::getZones();
    }
    public static function getGoldiranProducts($data,$id=null){
        return  self::getProducts();
    }
    public static function getFaqFromInput($data,$id=null){
        $str = Input::get('src');   
		$items = PageWidget::where('widget_id',52)
            ->where('xstatus',1)
            ->select('config')
            ->get();

        $newItems= [];
        foreach ($items as $key => $value) {
            $params = json_decode($value->config,false)->parameters;
            foreach ($params as $paramkey => $param) {
                if(Str::contains($param->question,$str) || Str::contains($param->answer,$str)){
                    $newItems[] = $param;
                }
            }
        }
        
        return array_slice($newItems,0,10);
    }

    public static function getComments($data,$id=null){
        if($id){
            $pageWidget = PageWidget::find($id);
            if($pageWidget){
                $comments = $pageWidget->comments()->with('replies')
                    ->where('xcomment_approved', 1)
                    ->where('xparentid',0)
                    ->orderBy('xparentid','asc')
                    ->orderBy('xcomment_date','desc')
                    ->get();
                
                return $comments;
            }
        }
        return null;
    }
}