<?php

namespace Modules\Home\Traits;
use Modules\Home\Models\Province;
use Modules\Home\Models\County;
use Modules\Home\Models\Region;
use Modules\Home\Models\Parish;

trait Location {
    public static function getZones(){
        $provinces = Province::all();
        $county = County::all();
        $region = Region::all();
        $parish = Parish::all();
        
        $provinceList =[0 => 'استان'];
        foreach ($provinces as $key => $value) {
            $provinceList[(int)$value->id] = $value->name;
        }
        
        $countyList = [];
        foreach ($county as $key => $value) {
            $countyList[(int)$value->province_id][(int)$value->id] =  $value->name;
        }
        
        $regionList = [];
        foreach ($region as $key => $value) {
            $regionList[(int)$value->city_id][(int)$value->id] =  $value->name;
        }

        $parishList = [];
        foreach ($parish as $key => $value) {
            $parishList[(int)$value->region_id][(int)$value->id] =  $value->name;
        }

        return [
            'provinceList' => $provinceList,
            'cityList' => $countyList,
            'regionList' => $regionList,
            'parishList' => $parishList,
            'fullProvinceList' => $provinces
        ];
    }

    public static function getPriorityZone(){
        $priorityData = Province::leftJoin('county as c','province.id','=','c.province_id')
                    ->leftJoin('region as r','r.city_id','=','c.id')
                    ->leftJoin('parish as pr','pr.region_id','=','r.id')
                    ->whereIn('province.id',[11,32])
                    ->select('province.id','province.name','c.id as city_id','c.name as city_name','r.id as region_id', 'r.name as region_name', 'pr.id as parish_id', 'pr.name as parish_name')
                    ->get();

        $provinces = Province::all();
        
        $provinceList = [];
        $countyList = [];
        $regionList = [];
        $parishList = [];
        $countyListD = [];
        $regionListD = [];
        $parishListD = [];

        foreach ($provinces as $key => $value) {
            $provinceList[] = ['label' => $value->name, 'value' => (int)$value->id];
        }
        
        foreach ($priorityData as $key => $value) {
            $countyListD[(int)$value->id][$value->city_id] = $value->city_name;
            $regionListD[(int)$value->city_id][$value->region_id] = $value->region_name;
            $parishListD[(int)$value->region_id][$value->parish_id] = $value->parish_name;
        }

        foreach ($countyListD as $key => $value) {
            foreach($value as $cKey => $cValue){
                $countyList[$key][] = ['label' => $cValue, 'value' => $cKey];
            }
        }

        foreach ($regionListD as $key => $value) {
            foreach($value as $cKey => $cValue){
                $regionList[$key][] = ['label' => $cValue, 'value' => $cKey];
            }
        }

        foreach ($parishListD as $key => $value) {
            foreach($value as $cKey => $cValue){
                $parishList[$key][] = ['label' => $cValue, 'value' => $cKey];
            }
        }
            
        return [
            'provinceList' => $provinceList,
            'cityList' => $countyList,
            'regionList' => $regionList,
            'parishList' => $parishList
        ];
    }

    public static function getCityZone($id){
        $county = County::where('province_id',$id)->get();
        $countyList = [];
        foreach ($county as $key => $value) {
            $countyList[] = ['label' => $value->name, 'value' => (int)$value->id];
        }
        return $countyList;
    }

    public static function getRegionZone($id){
        $region = Region::where('city_id',$id)->get();
        $regionList = [];
        foreach ($region as $key => $value) {
            $regionList[] = ['label' => $value->name, 'value' => (int)$value->id];
        }
        return $regionList;
    }

    public static function getParishZone($id){
        $parish = Parish::where('region_id',$id)->get();
        $parishList = [];
        foreach ($parish as $key => $value) {
            $parishList[] = ['label' => $value->name, 'value' => (int)$value->id];
        }
        return $parishList;
    }
}