<?php

namespace Modules\Home\Providers;

use Illuminate\Database\Eloquent\Factory;
use Illuminate\Support\ServiceProvider;
use Modules\Home\Entities\Logger;

class HomeServiceProvider extends ServiceProvider {
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Boot the application events.
     *
     * @return void
     */
    public function boot() {
        $this->registerTranslations();
        $this->registerConfig();
        $this->registerViews();
        $this->registerFactories();
        $this->loadMigrationsFrom(__DIR__ . '/../Database/Migrations');
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register() {
        $this->app->singleton('logger', function () {
            return new Logger();
        });
    }

    /**
     * Register config.
     *
     * @return void
     */
    protected function registerConfig() {
        $this->publishes([
            __DIR__ . '/../Config/config.php' => config_path('home.php'),
        ], 'config');
        $this->mergeConfigFrom(
            __DIR__ . '/../Config/config.php', 'home'
        );

        if (file_exists(__DIR__ . '/../Config/route.php')) {
            $this->mergeConfigFrom(
                __DIR__ . '/../Config/route.php', 'route'
            );
        }
    }

    /**
     * Register views.
     *
     * @return void
     */
    public function registerViews() {
        $viewPath = resource_path('views/modules/home');

        $sourcePath = __DIR__ . '/../Resources/views';

        $theme = config('app.theme', 'cppc');
        $newSourcePath = resource_path("views/index/{$theme}/modules/home/views");

        $this->publishes([
            $sourcePath => $viewPath,
        ], 'views');

        $this->loadViewsFrom(array_merge(array_map(function ($path) {
            return $path . '/modules/home';
        }, \Config::get('view.paths')), [$sourcePath, $newSourcePath]), 'home');
    }

    /**
     * Register translations.
     *
     * @return void
     */
    public function registerTranslations() {
        $langPath = resource_path('lang/modules/home');

        if (is_dir($langPath)) {
            $this->loadTranslationsFrom($langPath, 'home');
        } else {
            $this->loadTranslationsFrom(__DIR__ . '/../Resources/lang', 'home');
        }
    }

    /**
     * Register an additional directory of factories.
     *
     * @return void
     */
    public function registerFactories() {
        if (!app()->environment('production')) {
            app(Factory::class)->load(__DIR__ . '/../Database/factories');
        }
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides() {
        return [];
    }
}
