<?php namespace Modules\Home\Models;

use DB;
use stdClass;
use App\Models\Model;
use Modules\Book\Models\Book;
use Modules\Shop\Models\Product;
use Modules\Blog\Models\Article;
use App;

class Tag extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'xxtags';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'xtagid';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    protected $guarded = ['xtagid'];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        
    ];

    /**
     * Get all of the posts that are assigned this tag.
     */
    public function books()
    {
        return $this->morphedByMany(Book::class, 'taggable','xxtaggables','tag_id','taggable_id');
    }

    public function products()
    {
        return $this->morphedByMany(Product::class, 'taggable','xxtaggables','tag_id','taggable_id');
    }

       /**
     * Get all of the posts that are assigned this tag.
     */
    public function articles()
    {
        return $this->morphedByMany(Article::class, 'taggable','xxtaggables','tag_id','taggable_id');
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult()
    {
        $instance = new static();

        $res = DB::table($instance->table)
            ->select(['*', "{$instance->primaryKey} AS xid"])
            ->where('xlang' , App::getLocale());

        return $res;
    }

    public static function updateById($data,$id=0)
    {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id],$data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id)
    {
        $instance = new static();
        if ($id){
            $res = $instance->destroy($id);
            die('[[OK]]'); 
        }
        else
            die('[[Error]]');
        
        return $res;        
    }
}