<?php namespace Modules\Home\Models;

use DB;
use stdClass;
use App\Models\Model;
use App;
use Modules\Home\Models\Province;

class ProvinceAgent extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'province_agents';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
    public $lang = false;

    protected $guarded = ['id'];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'int',
    ];

    public function province(){
        return $this->belongsTo(Province::class, 'province_id');
    }


    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult()
    {
        $instance = new static();

        $res = DB::table($instance->table)
            ->select(['*', "{$instance->primaryKey} AS xid"])
            ->groupBy('xid');

        return $res;
    }

   public static function updateById($data,$id=0)
    {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id],$data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id)
    {
        $instance = new static();
        if ($id){
            
            $res = $instance->destroy($id);
            parent::deleteFile($id);
            die('[[OK]]'); 
        }
        else
            die('[[Error]]');
        
        return $res;        
    }

}