<?php namespace Modules\Home\Models;

use DB;
use stdClass;
use App\Models\Model;
use App;

class Online extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'sessions';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    protected $guarded = [];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
       
    ];

    /**
     * @param  $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeGuests($query)
    {
        return $query->whereNull('user_id');
    }

    /**
     * Returns all the registered users.
     *
     * @param  $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeRegistered($query)
    {
        return $query->whereNotNull('user_id')->with('user');
    }

    /**
     * Updates the session of the current user.
     *
     * @param  $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeUpdateCurrent($query)
    {
        return $query->where('id', Session::getId())->update(array(
                'user_id' => !trim(\Auth::check())==false ? \Auth::user()->id : null
            ));
    }

    /**
     * Returns the user that belongs to this entry.
     */
    public function user()
    {
        return $this->belongsTo('User');
    }


    public static function updateById($data,$id=0)
    {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id],$data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id)
    {
        $instance = new static();
        if ($id){
            $res = $instance->destroy($id);
            die('[[OK]]'); 
        }
        else
            die('[[Error]]');
        
        return $res;        
    }

}