<?php namespace Modules\Home\Models;

use App\Models\Model;
use DB;
use App;
class Menu extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'menu';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    protected $guarded = [];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'xrank' => 'int',
        'parent_id' => 'int',
    ];

    /**
     * Get the category that owns the sub category.
     */
    public function parent() {
        return $this->belongsTo(Menu::class, 'parent_id');
    }

    /**
     * Get the category that owns the sub category.
     */
    public function childs() {
        return $this->hasMany(Menu::class, 'parent_id');
    }

   

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table($instance->table . " AS g")
            ->leftJoin($instance->table . " AS gp","g.parent_id",'=',"gp.{$instance->primaryKey}")
            ->where('g.xlang' , App::getLocale())
            ->select(['g.*', "g.{$instance->primaryKey} AS xid","gp.name as parent"]);

        return $res;
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();

        $cond = (int) $id ? "{$instance->primaryKey} = '$id'" : $id;

        $res = $instance->newQuery()->whereRaw($cond)->delete();
        return $res;
    }
}