<?php namespace Modules\Home\Models;

use App\Models\Model;
use DB;

class Log extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'xxlog';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'xlogid';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
    public $lang = false;
    protected $guarded = ['xlogid'];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [

    ];
    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table($instance->table)
            ->leftJoin('xxsecurity_user as u', 'u.xuserid', '=', 'xxlog.xuserid')
            ->select([
                "{$instance->primaryKey} AS xid",
                "xxlog.*",
                "u.xusername",
            ]);

        return $res;
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();
        if ($id) {

            $res = $instance->destroy($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return $res;
    }

}