<?php namespace Modules\Home\Models;

use DB;
use stdClass;
use App\Models\Model;
use App;

class JobResume extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'job_resume';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = true;

    protected $guarded = ['id'];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'xrank' => 'int',
    ];

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult()
    {
        $instance = new static();

        $res = DB::table($instance->table)
            ->leftJoin('job','job.id','=',"$instance->table.job_id")
            ->select(['*', "{$instance->table}.{$instance->primaryKey} AS xid","job.name AS jobname","{$instance->table}.name AS resumename"])
            ->where("{$instance->table}.xlang" , App::getLocale());

        return $res;
    }

    public static function updateById($data,$id=0)
    {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id],$data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id)
    {
        $instance = new static();
        if ($id){
            
            $res = $instance->destroy($id);
            self::removeImage($id,'image');
            self::removeImage($id,'icon');
            die('[[OK]]'); 
        }
        else
            die('[[Error]]');
        
        return $res;        
    }

    public static function removeImage($id,$type= null){
        parent::deleteFile($id,$type);
    }
}