<?php namespace Modules\Home\Models;

use App\Models\Model;
use DB;

class IranCity extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'city';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    protected $guarded = ['id'];

    protected $casts = [
        
    ];

    public function parent() {
        return $this->hasOne(Page::class, 'xpageid', 'xparentid');
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table("$instance->table AS p1")
            ->leftJoin('xxpage AS p2', 'p1.xparentid', '=', 'p2.xpageid')
            ->select(['p1.*', "p1.{$instance->primaryKey} AS xid", "p2.xpage_title AS xparent_title"]);
        return $res;
    }

    public static function getCounties() {
        $instance = new static();

        $res = DB::table("county")->get();
        return $res;
    }

    public static function getProvince() {
        $instance = new static();

        $res = DB::table("province")->get();
        return $res;
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();

        if ($id) {
            $res = $instance->destroy($id);
            parent::deleteFile($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return $res;
    }
}