<?php namespace Modules\Home\Models;

use DB;
use stdClass;
use App\Models\Model;
use App;
use Modules\Goldiran\Models\ConsultingType;
use Modules\Goldiran\Models\CountPerDay;
use Modules\Goldiran\Models\CountPerMonth;
use Modules\Goldiran\Models\Duration;
use Modules\Goldiran\Models\ItemType;
use Modules\Goldiran\Models\InquiryType;
use Modules\Goldiran\Models\Meter;
use Modules\Goldiran\Models\TransferType;
use Modules\Goldiran\Models\WarehouseType;
use Modules\home\Models\County;
use Modules\Home\Models\Province;

class InquiryItem extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'inquiry_items';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
    public $lang = false;

    protected $guarded = ['id'];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'int',
    ];

    public function inquiry(){
        return $this->belongsTo(Inquiry::class);
    }

    public function inquiryType(){
        return $this->belongsTo(InquiryType::class,'inquiryType_id');
    }

    public function meter(){
        return $this->belongsTo(Meter::class,'meter_id');
    }

    public function warehouse(){
        return $this->belongsTo(Warehousetype::class,'warehouse_id');
    }
    
    public function itemType(){
        return $this->belongsTo(Itemtype::class,'itemType_id');
    }

    public function count(){
        return $this->belongsTo(Countperday::class); //Countpermonth, Duration
    }

    public function toProvince(){
        return $this->belongsTo(Province::class, 'toProvince_id');
    }

    public function fromProvince(){
        return $this->belongsTo(Province::class,'fromProvince_id');
    }

    public function transferType(){
        return $this->belongsTo(Transfertype::class,'transferType_id');
    }

    public function consultingType(){
        return $this->belongsTo(Consultingtype::class,'consultingType_id');
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult()
    {
        $instance = new static();

        $res = DB::table($instance->table)
            ->select(['*', "{$instance->primaryKey} AS xid"])
            ->groupBy('xid');

        return $res;
    }

   public static function updateById($data,$id=0)
    {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id],$data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id)
    {
        $instance = new static();
        if ($id){
            
            $res = $instance->destroy($id);
            parent::deleteFile($id);
            die('[[OK]]'); 
        }
        else
            die('[[Error]]');
        
        return $res;        
    }

}