<?php namespace Modules\Home\Http\Controllers\Index;

use App\Http\Controllers\IndexController;
use Modules\Book\Models\Book;
use Modules\Home\Models\Tag;
use Request;
use Session;
use Input;
use App;
use DB;
use Auth;
use Redirect;

class TagController extends IndexController {

	/**
	 * Show the application dashboard to the user.
	 *
	 * @return Response
	 */
	public function  index()
	{ 
		$sort= 'xproduct_rank';
		$orderby= 'desc';
		$topEvents =Book::getResult()
                    ->take(5)
                    ->get();

        $events =Book::getResult()
                    ->get();

        $breadcrumb[]=['title'=>'conference', 'href'=> 'conference'];
		$this->layout->breadcrumb = $breadcrumb;

      	$this->layout->title = trans('conference');
        $this->layout->content = view('index.conference', [
            'topEvents'=>$topEvents,
            'orderby'=>$orderby, 
            'sort'=>$sort,
            'events'=>$events
        ]);
	}
	
	public function list($id, $title=null)
	{

		$tag = Tag::find($id);

		$breadcrumb[]=['title'=>t('tag'), 'href'=> 'Tag'];
		$breadcrumb[]=['title'=> $tag->xtagname, 'href'=> ''];

		$this->layout->breadcrumb = $breadcrumb;		
		$this->layout->title2 = t('tag');
        $this->layout->content = view('home::index.tagDetail',[
        	'tag'=>$tag,
        ]);
	}

}
