<?php namespace Modules\Home\Http\Controllers\Index;

use App;
use App\Http\Controllers\IndexController;
use Input;
use Modules\Author\Models\Author;
use Modules\Blog\Models\Article;
use Modules\Book\Models\Book;
use Modules\Shop\Models\Product;
use Modules\Shop\Models\Brand;
use Modules\Publisher\Models\Publisher;
use Request;

class SearchController extends IndexController {

    /*
    |--------------------------------------------------------------------------
    | About Controller
    |--------------------------------------------------------------------------
    |
    | This controller renders your application's "dashboard" for users that
    | are authenticated. Of course, you are free to change or remove the
    | controller as you wish. It is just here to get your app started!
    |
     */

    /**
     * Show the application dashboard to the user.
     *
     * @return Response
     */
    public function index(){
        $str = Input::get('q');

        $title = "search result";
        $text = 'what can we help you with?';

        $this->layout->pagetitle = ['title' => $title, 'text' => $text];

        $items = $this->calculateData($str);

        $items = $items->paginate(30)->withPath(Request::url());
        $brands = Brand::all();

        $path = dirname(\View::getFinder()->find('shop::index.group.index'));
        $widgetConfig = json_decode(file_get_contents($path . '/config.json'),true);
        $this->layout->widgetConfig = $widgetConfig;

        $this->layout->content = view('shop::index.group.index', [
            'products' => $items,
            'brands' => $brands,
            'type' => 'product',
            'changed_filters' => [],
            'pathToAccess' => [],
            'sort' => 5,
            'id' => 0,
            'code' => 'all',
            'name' => 'نتایج جستجو'
        ]);
    }

    public function autosuggest(){
        $str = Input::get('q');
        $items = $this->calculateData($str)->select('id','name')->get();
        return response()->json(['items' => $items] )->header('access-control-allow-headers', 'Content-Type, Content-Length, Accept-Encoding, X-CSRF-Token')
        ->header('access-control-allow-credentials', 'true')
        ->header('access-control-allow-origin', '*') 
        ->header('access-control-allow-methods', 'POST, GET, OPTIONS'); 
    }

    private function calculateData($str){
        return 
        Product::where('xstatus', 1)
            ->where(function($q) use ($str){
            $q->where('name', 'like', "%{$str}%")
            ->orWhereIn('id',function($query) use ($str){
                $query->select('taggable_id')
                    ->from('xxtaggables')
                    ->where('taggable_type','Modules\Shop\Models\Product')
                    ->whereIn('tag_id',function($query) use ($str){
                        $query->select('xtagid')
                            ->from('xxtags')
                            ->where('xname','like',"%{$str}%");
                    });
            });
        })
        ->orderBy('shop_product.xrank', 'desc')
        ->orderBy('shop_product.quantity','desc');
    }

     private function index2() {
        $str = Input::get('src');
        $type = strtolower(Input::get('type'));
        $feefrom = Input::get('feeFrom');
        $feeto = Input::get('feeTo');

        // if (empty($str) && empty($feefrom) && empty($feeto)) {
        //     return redirect('/');
        // }

        $title = "search result";
        $text = 'what can we help you with?';

        $breadcrumb[] = ['title' => t($title), 'href' => ''];
        
        $this->layout->pagetitle = ['title' => $title, 'text' => $text];

        if ($type == 'blog') {

            $items = Article::where('xarticle_title', 'like', "%{$str}%")
                ->orWhere('xarticle_desc', 'like', "%{$str}%")
                ->orderBy('xrank', 'desc')
                ->getWithLocale();

            $this->layout->content = view('home::index.searchResult', [
                'articles' => $items,
                'type' => 'blog',
            ]);

        } elseif($type == 'product'){
            $items = Product::where('xstatus', 1)->where(function ($q) use ($str) {
                $q->where('name', 'like', "%{$str}%")
                    ->orWhere('description', 'like', "%{$str}%");
            })->orderBy('xrank', 'desc');

            $items = $items->paginate(30)->withPath(Request::url());
            $brands = Brand::all();

            $this->layout->content = view('shop::index.group', [
                'products' => $items,
                'brands' => $brands,
                'type' => 'product',
                'id' => 0,
                'name' => 'نتایج جستجو'
            ]);
        }
         else {

            $authors = Author::where('xauthor_name', 'like', "%{$str}%")
                ->orWhere('xauthor_desc', 'like', "%{$str}%")
                ->orderBy('xrank', 'desc')
                ->get();

            $publishers = Publisher::where('xpublisher_name', 'like', "%{$str}%")
                ->orWhere('xpublisher_desc', 'like', "%{$str}%")
                ->orderBy('xrank', 'desc')
                ->get();

            $items = Book::where('xbook_publish', 1)->where('xbook_editedid', null)->where(function ($q) use ($str, $authors, $publishers) {
                $q->where('xbook_title', 'like', "%{$str}%")
                    ->orWhere('xbook_desc', 'like', "%{$str}%")
                    ->orWhereHas('author', function ($query) use ($authors) {
                        $query->whereIn('xxbook_author.xauthorid', $authors->pluck('xauthorid'));
                    })
                    ->orWhereIn('xpublisherid', $publishers->pluck('xpublisherid'));
            })->orderBy('xrank', 'desc');

            if ($feefrom) {
                $items->where('xbook_hard_price', '>=', (int) $feefrom);
            }

            if ($feeto) {
                $items->where('xbook_hard_price', '<=', (int) $feeto);
            }

            $items = $items->paginate(30)->withPath(Request::url());

            $this->layout->content = view('home::index.searchResult', [
                'books' => $items,
                'authors' => $authors,
                'publishers' => $publishers,
                'type' => 'book',
            ]);
        }
        $this->layout->content->breadcrumb = $breadcrumb;
    }
}
