<?php namespace Modules\Home\Http\Controllers\Index;

use App\Http\Controllers\IndexController;
use Modules\Home\Models\Banner;
use Modules\Home\Models\JobResume;
use Modules\Home\Models\Job;
use Modules\Page\Models\PageWidget;
use Validator;
use Request;
use Input;
use File;
use Modules\Home\Models\Config as ConfigModel;

class JobsController extends IndexController
{

	/*
	|--------------------------------------------------------------------------
	| Home Controller
	|--------------------------------------------------------------------------
	|
	| This controller renders your application's "dashboard" for users that
	| are authenticated. Of course, you are free to change or remove the
	| controller as you wish. It is just here to get your app started!
	|
	*/

	/**
	 * Show the application dashboard to the user.
	 *
	 * @return Response
	 */
	public function  index()
	{

		$title = "jobs";
		$banners = Banner::where('xstatus', '1')->getWithLocale();
		$pagewidgets = PageWidget::with('widgets')->where('page_id', 13)->orderBy('xrank', 'asc')->getWithStatus();
		$jobs = Job::getWithStatus();

		$this->layout->title2 = t($title);
		$this->layout->content = view('home::index.jobs', [
			'banners' => $banners,
			'pagewidgets' => $pagewidgets,
			'jobs' => $jobs,
		]);
	}

	public function detail($id)
	{
		$job = Job::find($id);
		$this->layout->title2 = $job->name;
		$this->layout->content = view('home::index.jobs_detail', [
			'job' => $job,
		]);
	}

	public function sendResume()
	{

		$validator = Validator::make(Request::all(), [
			'mobile' => 'bail|required|numeric',
			'email' => 'required|max:64|regex:/^[^\+]+@.+$/i',
			'name' => 'required|max:128',
			'captcha' => 'required|captcha'
		]);

		if ($validator->fails()) {
			return back()->withErrors($validator)->withInput();
		}

		$id = Input::get('id');
		$name = Input::get('name');
		$mobile = Input::get('mobile');
		$email = Input::get('email');
		$file = Request::file('resumeFile');

		if($file && !($file->getClientOriginalExtension() == 'pdf' || $file->getClientOriginalExtension() == 'doc' || $file->getClientOriginalExtension() == 'docx'))
			return redirect()->back()->with(['status'=>"فقط فایل های PDF,DOC,DOCX قابلیت آپلود شدن دارند."]);	
		

		$params = [
			'name' => $name,
			'mobile' => $mobile,
			'email' => $email,
			'job_id' => $id,
			'file_ext' => $file ?  $file->getClientOriginalExtension() : null,
		];
		
		$resume = JobResume::updateById($params);

		if ($file) {
			
			$dirPath = str_finish(config('upload.JobResume'), '/');
			if (!$dirPath or $dirPath == '/') {
				die(trans('language.upload directory is not set in config file'));
			}
			if ($file->isValid()) {
				if (!is_dir($dirPath)) {
					File::makeDirectory($dirPath, 0755, true);
				}
				//$file->storeAs($dirPath,$resume->id .'.'. $file->getClientOriginalExtension());
				$file->move($dirPath, $resume->id.'.'. $file->getClientOriginalExtension());
			}
		
		}

		$config = ConfigModel::getWithLocale()->first();
		$config = json_decode($config->xconfig_data, true);
		$emails = $config['email']['career'];

		Mail::send('home::index.jobMail', $params, function($message) use ($params,$emails)
		{
			$message->from($params['email'], $params['name']);
			$message->to($emails)->subject('jobs Form');
		});


		return redirect()->back()->with(['status'=>"درخواست همکاری شما با موفقیت ثبت شد.        به زودی با شما تماس خواهیم گرفت"]);
	}
}
