<?php namespace Modules\Home\Http\Controllers\Index;

use App\Http\Controllers\IndexController;
use Modules\Home\Models\Contact;
use Modules\Home\Models\ContactForm;
use Modules\Home\Models\Inquiry;
use Modules\Home\Models\InquiryItem;
use Modules\Goldiran\Models\ConsultingType;
use Modules\Goldiran\Models\CountPerDay;
use Modules\Goldiran\Models\CountPerMonth;
use Modules\Goldiran\Models\Duration;
use Modules\Goldiran\Models\ItemType;
use Modules\Goldiran\Models\Meter;
use Modules\Goldiran\Models\WarehouseType;
use Modules\Goldiran\Models\TransferType;
use Modules\Home\Models\Config as ConfigModel;
use Validator;
use Request;
use Input;
use Mail;
use SMS;
use Modules\Home\Traits\Location;

class InquiryController extends IndexController {
	use Location;
	/*
	|--------------------------------------------------------------------------
	| Home Controller
	|--------------------------------------------------------------------------
	|
	| This controller renders your application's "dashboard" for users that
	| are authenticated. Of course, you are free to change or remove the
	| controller as you wish. It is just here to get your app started!
	|
	*/

	/**
	 * Show the application dashboard to the user.
	 *
	 * @return Response
	 */
	public function  index()
	{
        $title= "ثبت درخواست";
        $location = self::getZones();

		$Consultingtype= ConsultingType::all();
		$Countperday= CountPerDay::all();
		$Countpermonth= CountPerMonth::all();
		$Duration= Duration::all();
		$Itemtype= ItemType::all();
		$Meter= Meter::all();
		$Warehousetype= WarehouseType::all();
		$Transfertype= TransferType::all();

		$this->layout->content = view('home::index.inquiry',array_merge($location,[
			'Consultingtype' => $Consultingtype,
			'Countperday' => $Countperday,
			'Countpermonth' => $Countpermonth,
			'Duration' => $Duration,
			'Itemtype' => $Itemtype,
			'Meter' => $Meter,
			'Warehousetype' => $Warehousetype,
			'Transfertype' => $Transfertype
		]));
		$this->layout->title = "ثبت درخواست";
        $this->layout->description = "ثبت درخواست";
	}


	public function sendForm() {
		$rules = array(
			// 'captcha'		 => 'required|captcha'
	    );

	    $validator = Validator::make(Input::all(), $rules);
	    if ($validator->fails()) {
			return back()
                ->withErrors($validator)
                ->withInput();
	    }else {
	 		$info = Input::get('info');
			$data = [
				'personalType' => $info['personalType'],
				'firstName' => $info['p-fname'],
				'lastName' => $info['personalType'] == 1? $info['p-lname'] : $info['c-manager'],
				'email' =>  $info['personalType'] == 1 ? $info['p-email'] : $info['c-email'],
				'mobile' =>  $info['personalType'] == 1 ? $info['p-mobile'] : $info['c-mobile'],
				'company' =>  $info['c-company'] ,
				'activityType' => $info['c-activityType'],
				'address' => $info['address'],
				'province_id' => $info['provinceId'],
				'city_id' => $info['cityId'],
				'region_id' => $info['regionId'],
				'parish_id' => $info['parishId'],
			];
			$inquery = Inquiry::updateById($data);

			$requests = Input::get('r');
			
			foreach ($requests as $key => $value) {
				$data2 = [
					'inquiry_id' => @$inquery->id,
					'inquiryType_id' => @$value['svctypeid'],
					'meter_id' => @$value['meter'],
					'warehouse_id' => @$value['warehouseType'],
					'itemType_id' => @$value['itemType'],
					'count_id' => @$value['count'],
					'toProvince_id' => @$value['toProvince'],
					'fromProvince_id' => @$value['fromProvince'],
					'transferType_id' => @$value['transferType'],
					'consultingType_id' => @$value['consultingType'],
					'description' => @$value['description'],
				];
				$itemId = InquiryItem::updateById($data2);
			}

			$config = ConfigModel::getWithLocale()->first();
        	$config = json_decode($config->xconfig_data, true);
			$emails = $config['email']['inquiry'];

	    	Mail::send('home::index.inquiryMail', ['inquiry' => $inquery], function($message) use ($inquery,$emails)
			{
			    $message->from($inquery->email ?? 'siteRobot@glcplus.ir', $inquery->lastName);
			    $message->to($emails)->subject('Contact Form');
			});
			
			$requestText = "درخواست شما با شماره پیگیری {track} در سامانه ثبت گردید. GLC";
			$text = str_replace('{track}', $inquery->id, $requestText);
			//$smsResponse = SMS::send($text, $inquery->mobile);
			$smsResponse = SMS::send( $inquery->id, $inquery->mobile,null,'invoiceSuccess');
			return redirect()->back()->with(['success'=>t('form was submitted successfully.') ,'status'=>"success"]);
    	}
	}
}
