<?php namespace Modules\Home\Http\Controllers\Index;

use App;
use App\Http\Controllers\IndexController;
use Modules\Advertise\Models\Advertise;
use Modules\Blog\Models\Article;
use Modules\Book\Models\Book;
use Modules\Book\Models\BookQuery;
use Modules\Book\Models\Category;
use Modules\Home\Models\Banner;
use Modules\Home\Models\Partner;
use Modules\Home\Models\Tag;
use Modules\Page\Models\PageWidget;
use Modules\Shop\Models\Group;
use Modules\Blog\Entities\SeoSchema;

class HomeController extends IndexController {

    /*
    |--------------------------------------------------------------------------
    | Home Controller
    |--------------------------------------------------------------------------
    |
    | This controller renders your application's "dashboard" for users that
    | are authenticated. Of course, you are free to change or remove the
    | controller as you wish. It is just here to get your app started!
    |
     */

    /**
     * Show the application dashboard to the user.
     *
     * @return Response
     */
    public function index() {
        $orderby = 'desc';

        $lastArticles = Article::orderBy('xrank', 'desc')
            ->orderBy('created_at', 'desc')
            ->take(7)
            ->where('xstatus',1)
            ->where('xarticle_top',1)
            ->getWithLocale();

        $partners = Partner::all();
        $advertise = Advertise::leftJoin('xxadvertise_place', function ($join) {
            $join->on('xxadvertise.xplaceid', '=', 'xxadvertise_place.xplaceid');
        })->where('xlocation', 'Home')
            ->orderBy('xxadvertise_place.xrank', 'desc')
            ->orderBy('xxadvertise.xrank', 'desc')
            ->get();

        
        $bookList = [];
        if (config('app.shop') != 'product'){
            $queryBook = BookQuery::where('xplace', 'Home')
                ->orderBy('xrank', 'desc')
                ->take(10)
                ->get();
            foreach ($queryBook as $key => $value) {
                $bookList[$key]['title'] = $value['xtitle'];
                if ($value['xcategoryid']) {
                    $bookList[$key]['list'] = Category::find($value['xcategoryid'])->subCategory;
                    $bookList[$key]['type'] = 'category';
                    $bookList[$key]['link'] = '/Book/category/' . $value['xcategoryid'];
                } else {
                    $bookList[$key]['type'] = 'book';
                    $bookList[$key]['link'] = '/Book/query/' . $value['xqueryid'];
                    $bookList[$key]['list'] = Book::with(['author', 'publisher'])->where('xbook_publish', 1)->where('xbook_editedid', null)
                        ->when($value['xsubcategoryid'], function ($query, $data) {
                            return $query->whereIn('xsubcategoryid', explode(',', $data));
                        })
                        ->when($value['xpublisherid'], function ($query, $data) {
                            return $query->where('xpublisherid', $data);
                        })
                        ->when($value['xauthorid'], function ($query, $data) {
                            return $query->where('xauthorid', $data);
                        })
                        ->when($value['xtagid'], function ($query, $data) {
                            $tag = Tag::find($data);
                            return $query->whereIn('xbookid', $tag->books->pluck('xbookid'));
                        })
                        ->when($value['xsortby'], function ($query, $data) {
                            return $query->orderBy($data, 'desc');
                        })
                        ->when($value['xcount'], function ($query, $data) {
                            return $query->take($data);
                        })->get();
                }

            }
        }
        $ProductList[0]['list'] = Group::getWithLocale();
        $ProductList[0]['type'] = 'category';
        $ProductList[0]['link'] = '/Product/group/0';
        $ProductList[0]['title'] = 'محصولات صنایع ریخته گری داکتیل';

        $banners = Banner::where('xstatus', '1')->where('type',1)->getWithLocale();

        $pagewidgets = [];
        if($this->theme != 'cppc'){
            $pagewidgets = PageWidget::leftJoin('widget','widget.id','=','widget_id')
                                    ->where('page_id',1)
                                    ->where('widget_page.xstatus',1)
                                    ->where('widget.xstatus',1)
                                    ->orderBy('xrank','asc')
                                    ->select(['widget_page.config as values','widget.blade','widget_page.id as pageWidgetId'])
                                    ->get();
        }
        
        $this->layout->content = view('home::index.home',
            ['orderby' => $orderby,
                'bookList' => $bookList,
                'ProductList' => @$ProductList,
                'banners' => $banners,
                'lastArticles' => $lastArticles,
                'partners' => $partners,
                'advertise' => $advertise,
                'pagewidgets' => $pagewidgets,
            ]);

        $this->layout->schemaWebsite = json_encode(SeoSchema::schemaWebSite(),JSON_UNESCAPED_SLASHES);

    }
}
