<?php namespace Modules\Home\Http\Controllers\Index;

use App\Http\Controllers\IndexController;
use Modules\Home\Models\Faq;
use Modules\Blog\Models\Article;
use Modules\Goldiran\Models\Product;
use Validator;
use Request;
use Input;
use Mail;

class FaqController extends IndexController {

	/*
	|--------------------------------------------------------------------------
	| Home Controller
	|--------------------------------------------------------------------------
	|
	| This controller renders your application's "dashboard" for users that
	| are authenticated. Of course, you are free to change or remove the
	| controller as you wish. It is just here to get your app started!
	|
	*/

	/**
	 * Show the application dashboard to the user.
	 *
	 * @return Response
	 */
	public function  index()
	{
        
        $title= "faq";
		$faqs = Faq::where('controller',1)->getWithStatus();
		$lastArticles = Article::orderBy('xrank', 'desc')
            ->orderBy('created_at', 'desc')
			->take(7)
			->where('xstatus',1)
			->getWithLocale();

		$products = Product::where('show_repaire',1)->getWithStatus()->prepend(new Product(['id' => 0, 'name' => 'همه محصولات']));
			
      	$this->layout->title2 = trans($title);
        $this->layout->content = view('home::index.faq',[
			'title' => 'سوالات متداول خدمات گلدیران',
			'type' => 'Faq',
			'faqs' => $faqs,
			'lastArticles' => $lastArticles,
			'products' => $products,
		]);
	}

	public function filter(){

		$str = Input::get('src');
		$type = Input::get('type');
		
		$items = Faq::where('controller',1)
		->where('xstatus',1)
		->when($type, function ($query, $data) {
			return $query->where('type', $data);
		})
		->when($str, function ($query, $data) {
			return $query->where('question', 'like', "%{$data}%")->orWhere('answer', 'like', "%{$data}%");
		})
		->orderBy('xrank', 'desc')
		->getWithLocale();

		$lastArticles = Article::orderBy('xrank', 'desc')
            ->orderBy('created_at', 'desc')
            ->take(7)
			->getWithLocale();
		
		$products = Product::where('show_repaire',1)->getWithStatus()->prepend(new Product(['id' => 0, 'name' => 'همه محصولات']));
		
        $this->layout->content = view('home::index.faq',[
			'title' => 'سوالات متداول خدمات گلدیران',
			'type' => 'Faq',
			'faqs' => $items,
			'lastArticles' => $lastArticles,
			'products' => $products,
			'activeGroup' => $type ? $products->where('id',(int)$type)->first()->name : null,
		]);
	
	}


	
}
