<?php namespace Modules\Home\Http\Controllers\Index;

use App\Http\Controllers\IndexController;
use Modules\Home\Models\Contact;
use Modules\Home\Models\ContactForm;
use Modules\Home\Models\Config as ConfigModel;
use Validator;
use Request;
use Input;
use Mail;
use SMS;
use Modules\Home\Models\ProvinceAgent;

class ContactController extends IndexController {

	/*
	|--------------------------------------------------------------------------
	| Home Controller
	|--------------------------------------------------------------------------
	|
	| This controller renders your application's "dashboard" for users that
	| are authenticated. Of course, you are free to change or remove the
	| controller as you wish. It is just here to get your app started!
	|
	*/

	/**
	 * Show the application dashboard to the user.
	 *
	 * @return Response
	 */
	public function  index()
	{
        
        $title= "contact";
        
      	$contacts = Contact::getWithLocale();

		$this->layout->content = view('home::index.contact',['contacts' => $contacts]);
		$this->layout->title = t('contact');
        $this->layout->description = "جهت ارتباط و تماس با ما می توانید با شماره تلفن ۰۲۱-۸۴۷۳۳ و یا نشانی اینترنتی info@goldiran.ir با ما به صورت 24 ساعته و 7 روز هفته بدون تعطیلی در ارتباط باشید";
	}

	public function getAgents()
    {
        $id = Input::get('id');
        
        if (!$id)
            return response()->json(['success' => false, 'message' => 'مدل محصول یافت نشد'], 400);

        $result = ProvinceAgent::leftJoin('province','province_id','province.id')->where('name_en',$id)->pluck('text');
		
        if (empty($result))
            return response()->json(['success' => false, 'message' => 'نمایندگی برای این منطقه یافت نشد'], 400);

        return response()->json($result);
    }

	public function share(){
		$mobile = Input::get('mobile');
		$email = Input::get('email');

		try {
			if($mobile){
				$smsResponse = SMS::send('لینک زیر توسط دوست شما ارسال شده است.\n' . url()->previous(), $mobile, null, null);
			}
			if($email){
				$data = ['address' => url()->previous(),'email' => $email];
				
				Mail::send('home::index.shareMail', $data, function($message) use ($data)
				{
					$message->from('noreply@glcplus.net', 'شرکت GLC');
					$message->to($data['email'])->subject('اشتراک گذاری صفحه سایت GLC');
				});
			}
		} catch (\Throwable $th) {
			return redirect()->back()->with(['success'=>t('ارسال درخواست شما ناموفق بود. لطفا دوباره تلاش نمائید.') ,'status'=>"failed"]);
		}
		

		return redirect()->back()->with(['success'=>t('form was submitted successfully.') ,'status'=>"success"]);
	}


	public function sendForm() {
		$rules = array(
	        'name'           => 'required',
			'email'          => 'required|email',
			'mobile'         => 'required|numeric',
			'subject'        => 'required|numeric',
	        'msg'        	 => 'required',
			'captcha'		 => 'required|captcha'
	    );

	    $validator = Validator::make(Input::all(), $rules);
	    if ($validator->fails()) {
			return back()
                ->withErrors($validator)
                ->withInput();
	    }else {
	 		$contactName = Input::get('name');
			$contactEmail = Input::get('email');
			$contactMobile = Input::get('mobile');
			$contactSubject= Input::get('subject');
			$contactMsg = Input::get('msg');
			$data = array('name'=>$contactName, 'email'=>$contactEmail,'mobile' => $contactMobile, 'subject_id' => $contactSubject, 'description'=>$contactMsg );
			ContactForm::updateById($data);

			$config = ConfigModel::getWithLocale()->first();
        	$config = json_decode($config->xconfig_data, true);
			$emails = $config['email']['contactus'];

			Mail::send('home::index.contactMail', $data, function($message) use ($data,$emails)
			{
			    $message->from($data['email'], $data['name']);
			    $message->to($emails)->subject('Contact Form');
			});

			return redirect()->back()->with(['success'=>t('form was submitted successfully.') ,'status'=>"success"]);
    	}
	}
}
