<?php namespace Modules\Home\Http\Controllers\Index;

use App\Http\Controllers\IndexController;
use Modules\Home\Models\Contact;
use Modules\Home\Models\ContactInfo;
use Modules\Home\Models\Banner;
use Modules\Page\Models\PageWidget;
use Validator;
use Request;
use Input;
use Mail;

class AboutController extends IndexController
{

	/*
	|--------------------------------------------------------------------------
	| Home Controller
	|--------------------------------------------------------------------------
	|
	| This controller renders your application's "dashboard" for users that
	| are authenticated. Of course, you are free to change or remove the
	| controller as you wish. It is just here to get your app started!
	|
	*/

	/**
	 * Show the application dashboard to the user.
	 *
	 * @return Response
	 */
	public function  index()
	{

		$title = "about";
		$banners = Banner::where('xstatus', '1')->getWithLocale();
		$pagewidgets = PageWidget::with('widgets')->where('page_id', 6)->orderBy('xrank', 'asc')->getWithStatus();

		$this->layout->title2 = t($title);
		$this->layout->content = view('home::index.about', [
			'banners' => $banners,
			'pagewidgets' => $pagewidgets,     
		]);
	}
}
