<?php namespace Modules\Home\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Book\Models\Book;
use Modules\Book\Models\Category;
use Modules\Book\Models\SubCategory;
use Modules\Home\Models\Config;
use Storage;
use Zipper;

class VersionController extends BackendController {
    public $title = "config";
    private $tempFolder = "mobile-temp/";

    //## list
    public function index() {
        $this->field[] = array('php' => 'echo $item["xbasicinfo_section"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'xbasicinfo_section');
        $this->field[] = array('php' => 'echo $item["xbasicinfo_title"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'xbasicinfo_title');

        $config = Config::where('xtype', 'version')->getWithLocale()->first();
        $id = $config->xconfigid;
        $config = json_decode($config->xconfig_data, true);

        $this->layout->title = trans($this->title);
        $this->layout->custom = true;
        $this->layout->content = view('home::admin.edit.version', ['list' => $config, 'id' => $id]);
    }

    //## store
    public function store($id) {
        $config = Config::where('xtype', 'version')->where('xconfigid', $id)->first();
        $config = json_decode($config->xconfig_data, true);
        $config['mobile']['version']++;

        $this->createZipFile($config['mobile']['version']);

        $config = json_encode($config);
        Config::updateById(['xconfig_data' => $config], $id);

        return back();
    }

    private function createZipFile($version) {
        Storage::delete(Storage::files($this->tempFolder));
        $this->createBaseUrl($version);
        $this->createBooks();
        $this->createSubjects();

        $folder = storage_path("app/{$this->tempFolder}");

        Zipper::make("mobile/version/v{$version}.zip")->add([$folder . 'baseurl.txt', $folder . 'books.txt', $folder . 'subjects.txt'])->close();
    }

    private function createBaseUrl($version) {
        //file : baseurl.txt
        $baseLink = "http://digital.cppc.ir";
        $data = [
            $version,
            $baseLink . "/api/Rss/list",
            $baseLink . "/mobile",
            $baseLink . "/api/BookListFiles/bookfile_1.zip?v=" . $version,
            $baseLink . "/api/downloadBook",
            $baseLink . "/api/pic/book/w240h320",
            $baseLink . "/api/pic/book/w480h640",
            $baseLink,
        ];

        Storage::put($this->tempFolder . "baseurl.txt", implode("\r\n", $data));
    }

    private function createBooks() {
        //file : books.txt
        $books = Book::where('xbook_publish',1)->get();
        $data = [];
        foreach ($books as $key => $book) {

            $line = [
                $book->xbookid,
                $book->xbook_title,
                $book->author ? $book->author->implode('xauthor_name', '-') : " ",
                $book->category ? $book->category->xsubcategoryid : "-1",
                "-1",
                "-1",
                $book->xbook_year,
                $book->xbookid . ".ghm",
                $book->xbookid . ".png",
                "1998",
                "3855936",
                $book->xbook_hard_price,
                $book->xbook_publish,
                $book->publisher ? $book->publisher->xpublisherid : " ",
                $book->publisher ? $book->publisher->xpublisher_name : " ",
                "1",
                $book->xbook_version ? $book->xbook_version : "",
            ];
            $data[] = implode(',', $line);
        }
        Storage::put($this->tempFolder . "books.txt", implode("\r\n", $data));

    }

    private function createSubjects() {
        //file:subjects.txt
        $data = [];
        // $category = Category::where('xcategoryid', 11)->get();
        // foreach ($category as $key => $cat) {
        //     $line = [
        //         $cat->xcategoryid,
        //         "-1",
        //         $cat->xcategory_name,
        //         Category::getbookCount($cat->xcategoryid),
        //         " ",
        //         " ",
        //         " ",
        //     ];
        //     $data[] = implode(',', $line);
        // }
        $subCategory = SubCategory::all();
        foreach ($subCategory as $key => $subCat) {
            $line = [
                $subCat->xsubcategoryid,
                "-1",
                $subCat->xsubcategory_name,
                SubCategory::getbookCount($subCat->xsubcategoryid),
                " ",
                " ",
                " ",
            ];
            $data[] = implode(',', $line);
        }
        Storage::put($this->tempFolder . "subjects.txt", implode("\r\n", $data));
    }
}