<?php namespace Modules\Home\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Home\Models\Ticket;
use Config;
use Input;
use File;
use Auth;

class TicketController extends BackendController {
    public $title = "ticket";

    //## list
    public function index()
    {
        $this->field[] =  array('php' => 'echo $item["subject"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'subject');
        $this->field[] =  array('php' => 'echo Str::words($item["description"],25);', 'name' => trans('language.website'), 'css' => 'width: 10%', 'sortable' => 'description');
        $this->field[] =  array('php' => 'echo FarsiLib::g2jDate($item["created_at"],true);', 'name' => trans('language.date'), 'css' => 'width: 5%', 'sortable' => 'created_at');
        $this->field[] =  array('php' => 'echo $item["order"];', 'name' => trans('language.display rank'), 'css' => 'width: 5%', 'sortable' => 'order');
        $this->field[] =  array('php' => 'echo $item["xusername"];', 'name' => trans('language.user'), 'css' => 'width: 5%', 'sortable' => 'user_id');
    
        $this->list = Ticket::getResult();
        $this->paginate();
        $this->layout->content->listBtn['hideDelete'] = true;
        $this->layout->content->listBtn['hideEdit'] = true;
        $this->layout->content->listBtn['showpreview'] = true;
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'banner';
    }

    //## edit
    public function edit($id)
    {

        $this->layout->content->list = Ticket::find($id);
        $this->layout->content->imgExist = File::exists(config('upload.' . config('app.controller')) . "/$id");
        $this->layout->title = 'ticket';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $frm['user_id'] = Auth::id();
        $frm['parent_id'] = 0;
        $frm['is_customer'] = 1;
        $ticket = Ticket::updateById($frm, $id);
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        $res = Ticket::remove($id);
    }

    public function editpreview($id) {
        $this->layout->content = view('home::admin.edit.previewTicket');
        $this->layout->content->list = Ticket::find($id);
        $this->layout->title = 'ticket';
    }

    //## delete logo
    public function deleteImg($id)
    {
        $type = Input::get('type');
        Ticket::removeImage($id,$type);
        die('[[OK]]');
    }
}