<?php namespace Modules\Home\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Home\Models\Subscribe;
use Modules\Home\Exports\SubscribeExport;
use Input;
use View;

class SubscribeController extends BackendController {
    public $title = "subscribe";

    //## list
	public function index()
	{
        $this->field[] =  array('php' => 'echo $item["user_payload"];', 'name' => trans('language.mobile'), 'css' => 'width: 10%', 'sortable' => 'user_payload');
        $this->field[] =  array('php' => 'echo $item["ip"];', 'name' => trans('language.mobile'), 'css' => 'width: 10%', 'sortable' => 'ip');
        $this->field[] =  array('php' => 'echo FarsiLib::g2jDate($item["date"],true);', 'name' => trans('language.mobile'), 'css' => 'width: 10%', 'sortable' => 'date');
        $this->field[] =  array('php' => 'echo $item["user_agent"];', 'name' => trans('language.mobile'), 'css' => 'width: 10%', 'sortable' => 'user_agent');
        $this->field[] =  array('php' => 'echo $item["xinvoice_status"];', 'name' => trans('language.status'), 'css' => 'width: 10%', 'sortable' => 'xinvoice_status');
        $this->field[] =  array('php' => 'echo $item["xtransaction_key"];', 'name' => trans('language.confirm'), 'css' => 'width: 10%', 'sortable' => 'xtransaction_key');
        $this->field[] =  array('php' => 'echo $item["acts"];', 'name' => trans('language.action'), 'css' => 'width: 10%', 'sortable' => 'user_agent');
        
        $this->list = Subscribe::getResult();
        $this->paginate();
        $this->layout->content->listBtn['hideDelete'] = true;
        $this->layout->content->listBtn['hideEdit'] = true;
        $this->layout->toolbar['hideCreate'] = true;
        $this->layout->toolbar['showTools'] = true;
        $this->layout->content->listBtn['showCheckbox'] = true;
	}

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'subscribe';
    }

    
    //## edit
    public function edit($id)
    {

        $this->layout->content->list = Subscribe::find($id);
        $this->layout->title = 'subscribe';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $partner = Subscribe::updateById($frm, $id);
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        $res = Subscribe::remove($id);
    }

    //## set combo
    public function setCombo()
    {   
        //## get status list
        $statusList = Subscribe::fetchEnum('xsubscribe_status');
        $this->layout->statusList = $this->layout->content->statusList = $statusList;
    }

    
    public function excelExport() {
        $checkall = Input::get('checkall');
        $listchk = Input::get('listchk');

        $this->list = Subscribe::getResult();
        $this->list->columns = ['user_payload','xinvoice_status','ip','user_agent'];
        $this->list->selectRaw("PDATE(date) as date, " . 'REPLACE(
            REPLACE(
            REPLACE(GROUP_CONCAT(activity),\'{"action":"openPage","payload":""}\',\'بازکردن صحفه\') ,
            \'{"action":"paymentClick", "payload":""}\',\'کلیک بر روی پرداخت\'),
            \'{"action":"modalToggle", "payload":""}\',\'کلیک پرداخت اولیه\') AS acts');

        if (!$checkall && $listchk) {
            $this->list->whereIn('id', array_keys($listchk));
        }

        $this->setQueryToList();

        if (!$this->list->orders) {
            $this->list->orders = [[
                "column" => "id",
                "direction" => "desc",
            ]];
        }

        return (new SubscribeExport($this->list))->download('subscribe.xlsx');
    }
}