<?php namespace Modules\Home\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Home\Models\ProvinceAgent;
use Config;
use Input;
use File;
use App;

class ProvinceAgentController extends BackendController {
    public $title = "agent";

    //## list
    public function index()
    {
        $this->field[] =  array('php' => 'echo $item["province_id"];', 'name' => trans('language.province'), 'css' => 'width: 10%', 'sortable' => 'province_id');
        $this->field[] =  array('php' => 'echo $item["text"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'name');
    
        $this->list = ProvinceAgent::getResult();
        $this->paginate();
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'agent';
    }

    //## edit
    public function edit($id)
    {

        $this->layout->content->list = ProvinceAgent::find($id);     
        $this->layout->title = 'agent';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $banner = ProvinceAgent::updateById($frm, $id);
        
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        $res = ProvinceAgent::remove($id);
    }

    //## delete logo
    public function deleteImg($id)
    {
        $type = Input::get('type');
        ProvinceAgent::removeImage($id,$type);
        die('[[OK]]');
    }
}