<?php namespace Modules\Home\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Home\Models\Partner;
use Config;
use Input;
use File;
use App;

class PartnerController extends BackendController {
    public $title = "partner";

    //## list
    public function index()
    {
        $this->field[] =  array('php' => 'echo \'<div style="text-align: center;"><img src="/pic/partner/\' . $item["xpartnerid"] . "w120h100c1/". str_random() . ".png?nocache=1" . \'" alt="" /></div>\';',
           'name' => trans('language.picture'), 'css' => 'width: 3%');
        $this->field[] =  array('php' => 'echo $item["xpartner_title"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'xpartner_title');
        $this->field[] =  array('php' => 'echo Str::words($item["xpartner_website"],25);', 'name' => trans('language.website'), 'css' => 'width: 10%', 'sortable' => 'xpartner_website');
        $this->field[] =  array('php' => 'echo $item["xrank"];', 'name' => trans('language.display rank'), 'css' => 'width: 5%', 'sortable' => 'xrank');
    
        $this->list = Partner::getResult();
        $this->paginate();
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'banner';
    }

    //## edit
    public function edit($id)
    {

        $this->layout->content->list = Partner::find($id);
        $this->layout->content->imgExist = File::exists(config('upload.' . config('app.controller')) . "/$id");
        $this->layout->title = 'partner';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $partner = Partner::updateById($frm, $id);
        $this->saveFile($partner->xpartnerid);
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        $res = Partner::remove($id);
    }

    //## delete logo
    public function deleteImg($id)
    {
        $type = Input::get('type');
        Partner::removeImage($id,$type);
        die('[[OK]]');
    }
}