<?php namespace Modules\Home\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Home\Models\Menu;
use Config;
use Input;
use File;
use App;

class MenuController extends BackendController {
    public $title = "menu";

    //## list
    public function index()
    {
        $this->field[] =  array('php' => 'echo $item["id"];', 'name' => trans('language.id'), 'css' => 'width: 10%', 'sortable' => 'id');
        $this->field[] =  array('php' => 'echo $item["name"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'name');
        $this->field[] =  array('php' => 'echo $item["parent_id"];', 'name' => trans('language.parent'), 'css' => 'width: 10%', 'sortable' => 'parent_id');
        $this->field[] =  array('php' => 'echo $item["url"];', 'name' => t('link'), 'css' => 'width: 10%', 'sortable' => 'url');
        $this->field[] =  array('php' => 'echo $item["xrank"];', 'name' => trans('language.display rank'), 'css' => 'width: 5%', 'sortable' => 'xrank');
        $this->field[] =  array('php' => 'echo htmlStatus($item["xstatus"],["1"=>"success","0"=>"danger"]);', 'name' => @t('status'), 'css' => 'width: 10%', 'sortable' => 'xstatus');
    
        $this->list = Menu::getResult();
        $this->paginate();
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'menu';
    }

    //## edit
    public function edit($id)
    {

        $this->layout->content->list = Menu::find($id);     
        $this->layout->title = 'menu';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $banner = Menu::updateById($frm, $id);
        
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        $res = Menu::remove($id);
    }

    //## delete logo
    public function deleteImg($id)
    {
        $type = Input::get('type');
        Menu::removeImage($id,$type);
        die('[[OK]]');
    }
}