<?php namespace Modules\Home\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Home\Models\Log;

class LogController extends BackendController {
    public $title = "log";

    //## list
    public function index() {
        $this->field[] = array('php' => 'echo $item["xusername"];', 'name' => trans('language.user'), 'css' => 'width: 5%', 'sortable' => 'xusername');

        $this->field[] = array('php' => 'echo t(strtolower($item["xcontroller"]));', 'name' => trans('language.module'), 'css' => 'width: 8%');

        $this->field[] = array('php' => 'echo t($item["xaction"]);', 'name' => trans('language.action'), 'css' => 'width: 8%');

        $this->field[] = array('php' => 'echo $item["xitemid"];', 'name' => trans('language.id'), 'css' => 'width: 6%');

        $this->field[] = array('php' => 'echo FarsiLib::g2jDate($item["xdate"],true);', 'name' => trans('language.date'), 'css' => 'width: 10%');

        $this->list = Log::getResult();
        $this->paginate();

        $this->layout->content->listBtn['hideDelete'] = true;
        $this->layout->toolbar['hideCreate'] = true;
    }

    //## new
    public function create($id = 0) {
        $this->layout->title = 'banner';
    }

    //## edit
    public function edit($id) {

        $this->layout->content->list = Log::find($id);
        $this->layout->title = 'log';
    }

    //## store
    public function store($id) {
        die('[[OK]]');
    }

}