<?php namespace Modules\Home\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Home\Models\Job;
use Modules\Home\Models\JobResume;
use Config;
use Input;
use File;
use App;

class JobsController extends BackendController {
    public $title = "partner";

    //## list
    public function index()
    {
        $this->field[] =  array('php' => 'echo $item["name"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'name');
        $this->field[] =  array('php' => 'echo Str::words($item["abstract"],25);', 'name' => trans('language.website'), 'css' => 'width: 10%', 'sortable' => 'abstract');
        $this->field[] =  array('php' => 'echo $item["xrank"];', 'name' => trans('language.display rank'), 'css' => 'width: 5%', 'sortable' => 'xrank');
    
        $this->list = Job::getResult();
        $this->paginate();
        $this->layout->content->listBtn['showItems'] = true;
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'banner';
    }

    //## edit
    public function edit($id)
    {

        $this->layout->content->list = Job::find($id);
        $this->layout->content->imgExist = File::exists(config('upload.' . config('app.controller')) . "/$id");
        $this->layout->title = 'partner';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $partner = Job::updateById($frm, $id);
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        $res = Job::remove($id);
    }

    //## delete logo
    public function deleteImg($id)
    {
        $type = Input::get('type');
        Job::removeImage($id,$type);
        die('[[OK]]');
    }

    
    public function editItems($id) {
        $this->layout->title = 'edit items';
        $this->layout->storeMethod = 'storeItems';
        $this->layout->content = view('home::admin.edit.job_items');
        $this->layout->content->list = Job::find($id);

    }

    public function downloadResume($id) {
        $job = JobResume::find($id);
        $path = str_finish(config('upload.JobResume'), '/').$job->id.'.'.$job->file_ext;
        
        if(File::exists($path)){
            return response()->download($path);
        }
        die('[[file not find]]');
        
    }

    public function storeItems($id) {
        $frm = Input::get('frm');
        $invoice = Invoice::updateById($frm, $id);

        die('[[OK]]');
    }

    public function deleteItems($id) {
        if ($id) {
            $res = BookImage::remove($id);
            if (!$res) {
                alert(trans('language.this record can not be removed'));
                die('[[Error]]');
            } else {
                File::delete(Config::get('upload.' . Config::get('app.controller')) . "/gallery/$id");
                die('[[OK]]');
            }
        } else {
            die('[[Error]]');
        }
    }
}