<?php namespace Modules\Home\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Home\Models\Job;
use Modules\Home\Models\JobResume;
use Modules\Home\Exports\ResumeExport;
use Config;
use Input;
use File;
use App;
use DB;

class JobResumeController extends BackendController {
    public $title = "job resume";

    //## list
    public function index()
    {
        $this->field[] =  array('php' => 'echo $item["resumename"];', 'name' => trans('language.name'), 'css' => 'width: 10%', 'sortable' => 'name');
        $this->field[] =  array('php' => 'echo $item["mobile"];', 'name' => trans('language.mobile'), 'css' => 'width: 10%', 'sortable' => 'mobile');
        $this->field[] =  array('php' => 'echo $item["email"];', 'name' => trans('language.email'), 'css' => 'width: 10%', 'sortable' => 'email');
        $this->field[] =  array('php' => 'echo $item["jobname"];', 'name' => t('job'), 'css' => 'width: 15%', 'sortable' => 'job_id');
        $this->field[] =  array('php' => 'echo FarsiLib::g2jdate($item["updated_at"],true);', 'name' =>  trans('language.date'), 'css' => 'width: 15%', 'sortable' => 'updated_at');
        $this->field[] =  array('php' => 'echo $item["xrank"];', 'name' => trans('language.display rank'), 'css' => 'width: 5%', 'sortable' => 'xrank');
    
        $this->list = JobResume::getResult();
        $this->paginate();
        $this->layout->content->listBtn['hideEdit'] = true;
        $this->layout->content->listBtn['hideDelete'] = true;
        $this->layout->content->listBtn['showDownload'] = true;
        $this->layout->toolbar['showTools'] = true;
        $this->layout->content->listBtn['showCheckbox'] = true;
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'job resume';
    }

    //## edit
    public function edit($id)
    {

        $this->layout->content->list = Job::find($id);
        $this->layout->content->imgExist = File::exists(config('upload.' . config('app.controller')) . "/$id");
        $this->layout->title = 'partner';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $partner = Job::updateById($frm, $id);
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        $res = Job::remove($id);
    }

    //## delete logo
    public function deleteImg($id)
    {
        $type = Input::get('type');
        Job::removeImage($id,$type);
        die('[[OK]]');
    }

    public function download($id) {
        $job = JobResume::find($id);
        $path = str_finish(config('upload.JobResume'), '/').$job->id.'.'.$job->file_ext;
        
        if(File::exists($path)){
            return response()->download($path);
        }
        die('[[file not find]]');
        
    }

    //## set combo
    public function setCombo() {
        $this->layout->jobList = $this->layout->content->jobList = Job::where('xstatus',1)->pluck('name','id')->prepend('', '');;
    }

    public function excelExport() {
        $checkall = Input::get('checkall');
        $listchk = Input::get('listchk');

        $this->list = JobResume::getResult()
            ->select(["job.name AS jobname","job_resume.name AS resumename","mobile","email", DB::Raw('PDATE(updated_at)')]);
        if (!$checkall && $listchk) {
            $this->list->whereIn('job_resume.id', array_keys($listchk));
        }
        $this->setQueryToList();

        if (!$this->list->orders) {
            $this->list->orders = [[
                "column" => "job_resume.id",
                "direction" => "desc",
            ]];
        }

        return (new ResumeExport($this->list))->download('resumes.xlsx');
    }

    
}