<?php namespace Modules\Home\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Tracking\Models\Company;
use Auth;

class HomeController extends BackendController {

    /*
    |--------------------------------------------------------------------------
    | Home Controller
    |--------------------------------------------------------------------------
    |
    | This controller renders your application's "dashboard" for users that
    | are authenticated. Of course, you are free to change or remove the
    | controller as you wish. It is just here to get your app started!
    |
     */
    public $title = 'language.dashboard';

    /**
     * Show the application dashboard to the user.
     *
     * @return Response
     */

    public function index() {
        if(config('app.dashboardView') == 'tracking'){
            $userCompany =  Company::leftJoin('xxsecurity_module_permission','controllerable_id','=','btl_company.id')
                                ->where('xxsecurity_module_permission.controller','65')
                                ->where('xxsecurity_module_permission.type',6)
                                ->when(Auth::id() != 1,function($query){
                                    return $query->where('xxsecurity_module_permission.user_id',Auth::id());
                                })
                                ->groupBy('btl_company.id')
                                ->get();
            
            
        }
        $this->layout->custom = true;
        $this->layout->content = view('home::admin.edit.home',['userCompany' => $userCompany ?? []]);
    }

}
