<?php namespace Modules\Home\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Home\Models\Faq;
use Config;
use Input;
use File;
use App;

class FaqController extends BackendController {
    public $title = "banner";

    //## list
    public function index()
    {
        $this->field[] =  array('php' => 'echo $item["question"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'question');
        $this->field[] =  array('php' => 'echo $item["type"];', 'name' => trans('language.type'), 'css' => 'width: 10%', 'sortable' => 'type');
        $this->field[] =  array('php' => 'echo $item["controller"];', 'name' => t('controller'), 'css' => 'width: 10%', 'sortable' => 'type');
        $this->field[] =  array('php' => 'echo $item["xrank"];', 'name' => trans('language.display rank'), 'css' => 'width: 5%', 'sortable' => 'xrank');
        $this->field[] =  array('php' => 'echo htmlStatus($item["xstatus"],["1"=>"success","0"=>"danger"]);', 'name' => @t('status'), 'css' => 'width: 10%', 'sortable' => 'xstatus');
    
        $this->list = Faq::getResult();
        $this->paginate();
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'faq';
    }

    //## edit
    public function edit($id)
    {

        $this->layout->content->list = Faq::find($id);     
        $this->layout->title = 'faq';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $banner = Faq::updateById($frm, $id);
        
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        $res = Faq::remove($id);
    }

    //## delete logo
    public function deleteImg($id)
    {
        $type = Input::get('type');
        Banner::removeImage($id,$type);
        die('[[OK]]');
    }
}