<?php namespace Modules\Home\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use DB;
use Input;
use Modules\Home\Models\ContactForm;
use Modules\Home\Models\ContactFormSubject;

class ContactFormController extends BackendController {
    public $title = "contact msg";
    
    function __construct(){
        $this->model = ContactForm::with('subject');
        parent::__construct();
    }

    protected $scaffold = [
        'checkbox' => true,
        'footerSum' => true,
        'hideDelete' => true,
    ];
    
    protected  $fields = [
        'name' => [
            'name' => 'name',
            'listView' => true,
            'text' => 'نام',
            'orderable' => true,
            'width' => '80px',
            'type' => 'text'
        ],
        'mobile' => [
            'name' => 'mobile',
            'listView' => true,
            'text' => 'موبایل',
            'orderable' => true,
            'width' => '80px',
            'type' => 'text'
        ],
        'email' => [
            'name' => 'email',
            'listView' => true,
            'text' => 'ایمیل',
            'orderable' => true,
            'width' => '80px',
            'type' => 'text'
        ],
        'subject_id' => [
            'name' => 'subject',
            'listView' => true,
            'text' => 'موضوع',
            'orderable' => true,
            'width' => '80px',
            'type' => 'dynamicComboBox',
            'value' => 'name',
            'switchStatus' => 'switchStatus'
        ],
        'description' => [
            'name' => 'description',
            'text' => 'توضیحات',
            'listView' => false,
            'orderable' => true,
            'type' => 'textarea',
        ],
        'result' => [
            'name' => 'result',
            'text' => 'پاسخ',
            'listView' => false,
            'orderable' => true,
            'type' => 'textarea',
        ],
        'create_at' => [
            'name' => 'create_at',
            'text' => 'تاریخ',
            'orderable' => true,
            'listView' => true,
            'searchView' => true,
            'width' => '120px',
            'type' => 'pdateTime',
            'render' => 'persianDate'
        ],  
        'status' => [
            'name' => 'status',
            'text' => 'وضعیت',
            'listView' => true,
            'orderable' => true,
            'type' => 'switch',
            'width' => '60px',
            'render' => 'switchStatus'
        ],        
        'action' => [
            'name' => 'action',
            'text' => 'عملیات',
            'orderable' => false,
            'listView' => true,
            'className' => 'dt-left',
            'render' => 'defaultAction',
            'width' => '120px',
        ]
    ];

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'contact';
        $this->layout->content->contactList = [1];
    }

    public function edit($id)
    {
        $this->layout->content->values = ContactForm::find($id);
    }
    

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $contact = ContactForm::updateById($frm, $id);
        return redirect()->back()->with('status', '1');
    }

    //## delete
    public function delete($id)
    {
        if ($id) {
            $res = ContactForm::find($id);
            $res->info()->delete();
            $res->delete();
            return redirect()->back()->with('status', '1');
        } else {
            return redirect()->back()->with('status', '0');
        }
    }

    //## set combo
    public function setCombo() {
        $this->layout->subjectList = $this->layout->content->subjectList = ContactFormSubject::pluck('name','id')->prepend('','');
    }
}