<?php namespace Modules\Home\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use DB;
use Input;
use Modules\Home\Models\Contact;
use Modules\Home\Models\ContactInfo;

class ContactController extends BackendController {
    public $title = "contact";

    //## list
    public function index() {

        $this->field[] = array('php' => 'echo $item["xcontact_title"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'xcontact_title');
        $this->field[] = array('php' => 'echo $item["xcontact_desc"];', 'name' => @t('description'), 'css' => 'width: 10%', 'sortable' => 'xcontact_desc');
        $this->field[] = array('php' => 'echo $item["xrank"];', 'name' => trans('language.display rank'), 'css' => 'width: 5%', 'sortable' => 'xrank');

        $this->list = Contact::getResult();
        $this->paginate();
    }

    //## new
    public function create($id = 0) {
        $this->layout->title = 'contact';
        $this->layout->content->contactList = [1];
    }

    public function edit($id) {
        $contact = Contact::find($id);
        $this->layout->content->list = $contact;
        $this->layout->content->contactList = $contact->info->count() ? $contact->info : [1];
        $this->layout->title = 'contact';
    }
    //## edit

    //## store
    public function store($id) {
        $frm = Input::get('frm');
        $c = Contact::updateById($frm, $id);
        $contactList = Input::get('contactList');
        
        if ($contactList) {
            foreach ($contactList as $contact) {
                $c->info()->updateOrCreate(['xcontactinfoid' => $contact['xcontactinfoid']],$contact);
                //$contact['xcontactid'] = $c->xcontactid;
                //Contactinfo::updateById($contact, $contact['xcontactinfoid']);
            }
        }

        die('[[OK]]');

    }

    //## delete
    public function delete($id) {
        if ($id) {
            $res = Contact::find($id);
            $res->info()->delete();
            $res->delete();
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }
    }

    //## delete departman
    public function deleteContact($id) {
        if ($id) {
            $res = Contactinfo::remove($id);
            if (!$res) {
                alert(trans('language.this record can not be removed'));
                die('[[Error]]');
            } else {
                die('[[OK]]');
            }
        } else {
            die('[[Error]]');
        }
    }

    //## set combo
    public function setCombo() {
        $this->layout->titleList = $this->layout->content->titleList = ContactInfo::fetchEnum('xcontactinfo_type');
    }
}