<?php namespace Modules\Home\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use File;
use Input;
use Modules\Home\Models\Config;

class ConfigController extends BackendController {
    public $title = "config";

    //## list
    public function index() {
        $this->field[] = array('php' => 'echo $item["xbasicinfo_section"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'xbasicinfo_section');
        $this->field[] = array('php' => 'echo $item["xbasicinfo_title"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'xbasicinfo_title');

        $config = Config::where('xtype', 'config')->getWithLocale()->first();
        $id = $config->xconfigid;
        $config = json_decode($config->xconfig_data, true);

        $this->layout->title = trans($this->title);
        $this->layout->custom = true;
        $this->layout->content = view('home::admin.edit.config', ['list' => $config, 'id' => $id]);
    }

    //## new
    public function create($id = 0) {
        $this->layout->title = 'banner';
    }

    //## edit
    public function edit($id) {

        $this->layout->content->list = Config::find($id);
        $this->layout->content->imageExist1 = File::exists(config('upload.' . config('app.controller')) . "/image" . "/$id");
        $this->layout->content->imageExist2 = File::exists(config('upload.' . config('app.controller')) . "/icon" . "/$id");
        $this->layout->title = 'banner';
    }

    //## store
    public function store($id) {
        $frm = Input::get('frm');
        $config = json_encode($frm);
        $banner = Config::updateById(['xconfig_data' => $config], $id);

        return back();
    }

    //## delete
    public function delete($id) {
        $res = Config::remove($id);
    }

    //## delete logo
    public function deleteImg($id) {
        $type = Input::get('type');
        Config::removeImage($id, $type);
        die('[[OK]]');
    }
}