<?php namespace Modules\Home\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Home\Models\Banner;
use Config;
use Input;
use File;
use App;

class BannerController extends BackendController {
    public $title = "banner";

    //## list
    public function index()
    {
        $this->field[] =  array('php' => 'echo \'<div style="text-align: center;"><img src="/pic/banner.image/\' . $item["xbannerid"] . "w120h100c1/". str_random() . ".png?nocache=1" . \'" alt="" /></div>\';',
           'name' => trans('language.picture'), 'css' => 'width: 3%');
        $this->field[] =  array('php' => 'echo $item["xbanner_title"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'xbanner_title');
        $this->field[] =  array('php' => 'echo $item["xbanner_subtitle"];', 'name' => @t('subtitle'), 'css' => 'width: 10%', 'sortable' => 'xbanner_subtitle');
        $this->field[] =  array('php' => 'echo Str::words($item["xbanner_desc"],25);', 'name' => @t('description'), 'css' => 'width: 10%', 'sortable' => 'xbanner_desc');
        $this->field[] =  array('php' => 'echo $item["xrank"];', 'name' => trans('language.display rank'), 'css' => 'width: 5%', 'sortable' => 'xrank');
        $this->field[] =  array('php' => 'echo htmlStatus($item["xstatus"],["1"=>"success","0"=>"danger"]);', 'name' => @t('status'), 'css' => 'width: 10%', 'sortable' => 'xstatus');
    
        $this->list = Banner::getResult();
        $this->paginate();
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'banner';
    }

    //## edit
    public function edit($id)
    {

        $this->layout->content->list = Banner::find($id);     
        $this->layout->content->imageExist1 = File::exists(config('upload.' . config('app.controller')) ."/image". "/$id");
        $this->layout->content->imageExist2 = File::exists(config('upload.' . config('app.controller')) ."/icon". "/$id");
        $this->layout->title = 'banner';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $banner = Banner::updateById($frm, $id);
        $this->saveFile($banner->xbannerid);
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        $res = Banner::remove($id);
    }

    public function setCombo()
    {   
        $bannerList = [
            '1' => 'صفحه اصلی',
            '2' => 'تمدید گارانتی',
            '3' => 'سرویس دوره ای',
            '4' => 'نصب',
            '5' => 'تعمیر',
            '6' => 'درباره ما',
            '7' => 'صفححه داخلی تعمیرات',
            '8' => 'تماس با ما', 
            '9' => 'درخواست سرویس',
            '10' => 'دفترچه راهنما ',
            '11' => 'کنترل گارانتی',
            '12' => 'پیگیری درخواست',
            '13' => 'همکاری با ما', 
        ];
        $this->layout->bannerList = $this->layout->content->bannerList = $bannerList;
    }

    //## delete logo
    public function deleteImg($id)
    {
        $type = Input::get('type');
        Banner::removeImage($id,$type);
        die('[[OK]]');
    }
}